/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.dao.v1;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractTruncateColumnSubtask;
import com.atlassian.bitbucket.internal.branch.model.dao.v0.AoBranchModelConfigurationV0;
import com.atlassian.bitbucket.server.StorageService;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.java.ao.Query;

public class MigrateBranchModelToV1Subtask
extends AbstractTruncateColumnSubtask<AoBranchModelConfigurationV0> {
    private static final String TABLE_NAME = "BRANCH_MODEL";

    public MigrateBranchModelToV1Subtask(StorageService storageService) {
        super(storageService, TABLE_NAME, 450);
    }

    protected List<String> getColumnNames() {
        return ImmutableList.builder().add((Object)"REPOSITORY_ID").add((Object)"IS_ENABLED").add((Object)"DEV_ID").add((Object)"DEV_USE_DEFAULT").add((Object)"PROD_ID").add((Object)"PROD_USE_DEFAULT").build();
    }

    protected List<String> getRowValues(AoBranchModelConfigurationV0 row) {
        return ImmutableList.builder().add((Object)String.valueOf(row.getRepositoryId())).add((Object)String.valueOf(row.isEnabled())).add((Object)row.getDevelopmentBranchId()).add((Object)String.valueOf(row.isDevelopmentBranchUseDefault())).add((Object)row.getProductionBranchId()).add((Object)String.valueOf(row.isProductionBranchUseDefault())).build();
    }

    protected List<AoBranchModelConfigurationV0> selectRowsToProcess(ActiveObjects ao, int pageSize) {
        AoBranchModelConfigurationV0[] result = (AoBranchModelConfigurationV0[])ao.find(AoBranchModelConfigurationV0.class, Query.select().where(Joiner.on((String)" OR ").join((Object)this.columnLengthViolatesLimitClause("DEV_ID", ao), (Object)this.columnLengthViolatesLimitClause("PROD_ID", ao), new Object[0]), new Object[0]).limit(pageSize));
        return result == null ? Collections.emptyList() : Arrays.asList(result);
    }

    protected void truncateRowData(AoBranchModelConfigurationV0 row) {
        row.setDevelopmentBranchId(this.truncateLongValue(row.getDevelopmentBranchId()));
        row.setProductionBranchId(this.truncateLongValue(row.getProductionBranchId()));
    }
}

