/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.dao.v2;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.dao.AoScopeCascadingMergeConfig;
import com.atlassian.bitbucket.internal.branch.model.dao.AoBranchTypeConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.AoScopeBranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.dao.v1.AoBranchModelConfigurationV1;
import com.atlassian.bitbucket.internal.branch.model.dao.v1.AoBranchTypeConfigurationV1;
import com.atlassian.bitbucket.scope.ScopeType;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.java.ao.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MigrateToV2Task
implements ActiveObjectsUpgradeTask {
    private static final Query BRANCH_MODEL_CONFIG_QUERY = Query.select((String)Joiner.on((String)",").join((Object)"REPOSITORY_ID", (Object)"IS_ENABLED", new Object[]{"DEV_ID", "DEV_USE_DEFAULT", "PROD_ID", "PROD_USE_DEFAULT"}));
    private static final Logger log = LoggerFactory.getLogger(MigrateToV2Task.class);

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"2");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"1")), (Object)"This upgrade task can only upgrade from version 1 to version 2");
        log.info("Migrating branch model to version 2");
        ao.migrate(new Class[]{AoBranchModelConfigurationV1.class, AoBranchTypeConfigurationV1.class, AoScopeBranchModelConfiguration.class, AoBranchTypeConfiguration.class, AoScopeCascadingMergeConfig.class});
        ao.executeInTransaction(() -> {
            ao.stream(AoBranchModelConfigurationV1.class, BRANCH_MODEL_CONFIG_QUERY, branchModelConfigurationV1 -> {
                log.debug(String.format("Migrating branch model data for repository with ID %s", branchModelConfigurationV1.getRepositoryId()));
                String branchTypeConfigCriteria = "FK_BM_ID = " + branchModelConfigurationV1.getRepositoryId();
                AoBranchTypeConfigurationV1[] branchTypes = (AoBranchTypeConfigurationV1[])ao.find(AoBranchTypeConfigurationV1.class, branchTypeConfigCriteria, new Object[0]);
                this.migrate(ao, (AoBranchModelConfigurationV1)branchModelConfigurationV1, branchTypes);
                log.debug(String.format("Migration of branch model data complete for repository with ID %s", branchModelConfigurationV1.getRepositoryId()));
            });
            return null;
        });
        log.info("Branch model migration complete");
    }

    private void migrate(ActiveObjects ao, AoBranchModelConfigurationV1 v1Config, AoBranchTypeConfigurationV1[] v1TypeConfigs) {
        if (v1Config.isEnabled()) {
            ImmutableMap.Builder modelConfigurationBuilder = ImmutableMap.builder().put((Object)"RESOURCE_ID", (Object)v1Config.getRepositoryId()).put((Object)"SCOPE_TYPE", (Object)ScopeType.REPOSITORY).put((Object)"DEV_USE_DEFAULT", (Object)v1Config.isDevelopmentBranchUseDefault()).put((Object)"PROD_USE_DEFAULT", (Object)v1Config.isProductionBranchUseDefault());
            if (v1Config.getDevelopmentBranchId() != null) {
                modelConfigurationBuilder.put((Object)"DEV_ID", (Object)v1Config.getDevelopmentBranchId());
            }
            if (v1Config.getProductionBranchId() != null) {
                modelConfigurationBuilder.put((Object)"PROD_ID", (Object)v1Config.getProductionBranchId());
            }
            AoScopeBranchModelConfiguration branchModelConfig = (AoScopeBranchModelConfiguration)ao.create(AoScopeBranchModelConfiguration.class, (Map)modelConfigurationBuilder.build());
            for (AoBranchTypeConfigurationV1 typeConfiguration : v1TypeConfigs) {
                ImmutableMap.Builder typeConfigurationBuilder = ImmutableMap.builder().put((Object)"BM_ID", (Object)branchModelConfig.getID()).put((Object)"TYPE_ID", (Object)typeConfiguration.getTypeId()).put((Object)"IS_ENABLED", (Object)typeConfiguration.isEnabled());
                if (typeConfiguration.getPrefix() != null) {
                    typeConfigurationBuilder.put((Object)"PREFIX", (Object)typeConfiguration.getPrefix());
                }
                ao.create(AoBranchTypeConfiguration.class, (Map)typeConfigurationBuilder.build());
            }
        } else {
            ImmutableMap.Builder modelConfigurationBuilder = ImmutableMap.builder().put((Object)"RESOURCE_ID", (Object)v1Config.getRepositoryId()).put((Object)"SCOPE_TYPE", (Object)ScopeType.REPOSITORY).put((Object)"DEV_USE_DEFAULT", (Object)true).put((Object)"PROD_USE_DEFAULT", (Object)false);
            AoScopeBranchModelConfiguration branchModelConfig = (AoScopeBranchModelConfiguration)ao.create(AoScopeBranchModelConfiguration.class, (Map)modelConfigurationBuilder.build());
            for (AoBranchTypeConfigurationV1 typeConfiguration : v1TypeConfigs) {
                ImmutableMap.Builder typeConfigurationBuilder = ImmutableMap.builder().put((Object)"BM_ID", (Object)branchModelConfig.getID()).put((Object)"IS_ENABLED", (Object)false);
                if (typeConfiguration.getTypeId() != null) {
                    typeConfigurationBuilder.put((Object)"TYPE_ID", (Object)typeConfiguration.getTypeId());
                }
                if (typeConfiguration.getPrefix() != null) {
                    typeConfigurationBuilder.put((Object)"PREFIX", (Object)typeConfiguration.getPrefix());
                }
                ao.create(AoBranchTypeConfiguration.class, (Map)typeConfigurationBuilder.build());
            }
            ImmutableMap.Builder build = ImmutableMap.builder().put((Object)"SCOPE_TYPE", (Object)ScopeType.REPOSITORY).put((Object)"RESOURCE_ID", (Object)v1Config.getRepositoryId()).put((Object)"ENABLED", (Object)false);
            ao.create(AoScopeCascadingMergeConfig.class, (Map)build.build());
        }
    }
}

