/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.event;

import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.event.ApplicationEvent;
import com.atlassian.bitbucket.event.annotation.TransactionAware;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchConfiguration;
import com.atlassian.bitbucket.scope.Scope;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@TransactionAware
public abstract class BranchModelConfigurationEvent
extends ApplicationEvent {
    protected final BranchModelConfiguration newConfiguration;
    protected final BranchModelConfiguration oldConfiguration;

    public BranchModelConfigurationEvent(@Nonnull Object source, @Nonnull BranchModelConfiguration newConfiguration, @Nullable BranchModelConfiguration oldConfiguration) {
        super(source);
        this.newConfiguration = Objects.requireNonNull(newConfiguration, "newConfiguration");
        this.oldConfiguration = oldConfiguration;
    }

    public Map<String, Boolean> getBranchTypes() {
        return this.newConfiguration.getTypes().stream().collect(Collectors.toMap(BranchType::getId, BranchTypeConfiguration::isEnabled));
    }

    @Nonnull
    public RestBranchConfiguration getDevelopment() {
        return new RestBranchConfiguration(this.newConfiguration.getDevelopment());
    }

    @Nonnull
    public BranchModelConfiguration getNewConfiguration() {
        return this.newConfiguration;
    }

    @Nonnull
    public Optional<BranchModelConfiguration> getOldConfiguration() {
        return Optional.ofNullable(this.oldConfiguration);
    }

    @Nullable
    public RestBranchConfiguration getProduction() {
        BranchConfiguration production = this.newConfiguration.getProduction();
        if (production == null) {
            return null;
        }
        return new RestBranchConfiguration(production);
    }

    public Scope getScope() {
        return this.newConfiguration.getScope();
    }
}

