/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchModel;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.plugins.rest.api.security.annotation.LicensedOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;

@Path(value="projects/{projectKey}/repos/{repositorySlug}/branchmodel")
@Singleton
@LicensedOnly
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
public class BranchModelRepositoryResource {
    private final BranchModelService branchModelService;

    @Inject
    public BranchModelRepositoryResource(BranchModelService branchModelService) {
        this.branchModelService = branchModelService;
    }

    @GET
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response getBranchModel(@BeanParam RepositoryResolver repositoryResolver) {
        BranchModel model = this.branchModelService.getModel(repositoryResolver.getRepository());
        return ResponseFactory.ok((Object)((Object)new RestBranchModel(model))).build();
    }
}

