/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.rest;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchType;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.repository.RestBranch;
import com.atlassian.bitbucket.util.MoreStreams;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Objects;
import java.util.stream.Collectors;

@JsonSerialize
@JsonSurrogate(value=BranchModel.class)
public class RestBranchModel
extends RestMapEntity {
    public static final String DEVELOPMENT_BRANCH = "development";
    public static final String PRODUCTION_BRANCH = "production";
    public static final String TYPES = "types";

    public RestBranchModel() {
    }

    public RestBranchModel(@Nonnull BranchModel model) {
        this(model.getDevelopment(), model.getProduction(), model.getTypes());
    }

    public RestBranchModel(@Nonnull Branch devBranch, @Nullable Branch prodBranch, @Nonnull Iterable<BranchType> types) {
        this.put(DEVELOPMENT_BRANCH, new RestBranch(devBranch));
        if (prodBranch != null) {
            this.put(PRODUCTION_BRANCH, new RestBranch(prodBranch));
        }
        this.put(TYPES, MoreStreams.streamIterable(Objects.requireNonNull(types, TYPES)).map(RestBranchType.REST_TRANSFORM).collect(Collectors.toList()));
    }
}

