/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.rest;

import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchConfiguration;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchTypeConfiguration;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.atlassian.bitbucket.rest.v2.api.scope.RestScope;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Collections;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=BranchModelConfiguration.class)
public class RestBranchModelConfiguration
extends RestMapEntity {
    private static final String USE_DEFAULT = "useDefault";
    private static final String DEVELOPMENT = "development";
    private static final String PRODUCTION = "production";
    private static final String SCOPE = "scope";
    private static final String TYPES = "types";

    public RestBranchModelConfiguration() {
    }

    public RestBranchModelConfiguration(@Nonnull BranchModelConfiguration configuration) {
        this.put(DEVELOPMENT, (Object)new RestBranchConfiguration(configuration.getDevelopment()));
        if (configuration.getProduction() != null) {
            this.put(PRODUCTION, (Object)new RestBranchConfiguration(configuration.getProduction()));
        }
        this.put(TYPES, Collections2.transform(configuration.getTypes(), RestBranchTypeConfiguration.REST_TRANSFORM));
        this.put(SCOPE, new RestScope(configuration.getScope()));
    }

    private RestBranchModelConfiguration(Map<String, Object> json) {
        super(json);
    }

    @Nullable
    public static RestBranchModelConfiguration valueOf(@Nullable Object value) {
        if (value instanceof RestBranchModelConfiguration) {
            return (RestBranchModelConfiguration)((Object)value);
        }
        if (value instanceof Map) {
            return new RestBranchModelConfiguration((Map)value);
        }
        return null;
    }

    public boolean isUseDefault() {
        return this.getBoolProperty(USE_DEFAULT);
    }

    public Iterable<RestBranchTypeConfiguration> getTypes() {
        if (this.get(TYPES) == null) {
            return Collections.emptyList();
        }
        return Iterables.transform((Iterable)((Iterable)this.get(TYPES)), RestBranchTypeConfiguration.REST_TRANSFORM);
    }

    public RestBranchConfiguration getDevelopmentBranch() {
        return RestBranchConfiguration.valueOf(this.get(DEVELOPMENT));
    }

    public RestBranchConfiguration getProductionBranch() {
        return RestBranchConfiguration.valueOf(this.get(PRODUCTION));
    }

    public RestScope getScope() {
        return RestScope.valueOf((Object)this.get(SCOPE));
    }
}

