/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.rest;

import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=InternalBranchType.class)
public class RestBranchType
extends RestMapEntity {
    public static final String ID = "id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String PREFIX = "prefix";
    public static final Function<Object, RestBranchType> REST_TRANSFORM = new Function<Object, RestBranchType>(){

        public RestBranchType apply(Object input) {
            return RestBranchType.valueOf(input);
        }
    };

    public RestBranchType() {
    }

    public RestBranchType(@Nonnull BranchType type) {
        this(type.getId(), type.getDisplayName(), RestBranchType.getPrefix(type));
    }

    private RestBranchType(@Nonnull String id, @Nullable String name, @Nullable String prefix) {
        this.put(ID, id);
        this.putIfNotNull(DISPLAY_NAME, name);
        this.putIfNotNull(PREFIX, prefix);
    }

    private RestBranchType(Map<String, Object> values) {
        super(values);
    }

    public static RestBranchType valueOf(Object value) {
        if (value instanceof RestBranchType) {
            return (RestBranchType)((Object)value);
        }
        if (value instanceof BranchType) {
            return new RestBranchType((BranchType)value);
        }
        if (value instanceof Map) {
            return new RestBranchType((Map)value);
        }
        return null;
    }

    private static String getPrefix(BranchType branchType) {
        if (branchType instanceof InternalBranchType) {
            return ((InternalBranchType)InternalBranchType.class.cast(branchType)).getPrefix();
        }
        return null;
    }

    @Schema(example="Bugfix")
    public String getDisplayName() {
        return this.getStringProperty(DISPLAY_NAME);
    }

    @Schema(example="BUGFIX")
    public String getId() {
        return this.getStringProperty(ID);
    }

    @Schema(example="bugfix/")
    public String getPrefix() {
        return this.getStringProperty(PREFIX);
    }
}

