/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.rest;

import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.rest.v2.api.RestMapEntity;
import com.atlassian.bitbucket.rest.v2.api.annotation.JsonSurrogate;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Function;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.Map;

@JsonSerialize
@JsonSurrogate(value=BranchTypeConfiguration.class)
public class RestBranchTypeConfiguration
extends RestMapEntity {
    public static final String ID = "id";
    public static final String DISPLAY_NAME = "displayName";
    public static final String PREFIX = "prefix";
    public static final String ENABLED = "enabled";
    public static final Function<Object, RestBranchTypeConfiguration> REST_TRANSFORM = new Function<Object, RestBranchTypeConfiguration>(){

        public RestBranchTypeConfiguration apply(Object input) {
            return RestBranchTypeConfiguration.valueOf(input);
        }
    };

    public RestBranchTypeConfiguration() {
    }

    public RestBranchTypeConfiguration(@Nonnull BranchTypeConfiguration configuration) {
        this(configuration.getId(), configuration.getDisplayName(), configuration.isEnabled(), configuration.getPrefix());
    }

    private RestBranchTypeConfiguration(@Nonnull String id, @Nonnull String displayName, boolean enabled, @Nullable String prefix) {
        this.put(ID, id);
        this.put(DISPLAY_NAME, displayName);
        this.put(ENABLED, enabled);
        this.putIfNotNull(PREFIX, prefix);
    }

    private RestBranchTypeConfiguration(Map<String, Object> values) {
        super(values);
    }

    @Nullable
    public static RestBranchTypeConfiguration valueOf(@Nullable Object value) {
        if (value instanceof RestBranchTypeConfiguration) {
            return (RestBranchTypeConfiguration)((Object)value);
        }
        if (value instanceof BranchTypeConfiguration) {
            return new RestBranchTypeConfiguration((BranchTypeConfiguration)value);
        }
        if (value instanceof Map) {
            return new RestBranchTypeConfiguration((Map)value);
        }
        return null;
    }

    public String getId() {
        return this.getStringProperty(ID);
    }

    public String getPrefix() {
        return this.getStringProperty(PREFIX);
    }

    public boolean isEnabled() {
        return this.getBoolProperty(ENABLED);
    }
}

