/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.restriction.matcher;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.internal.branch.model.restriction.type.ModelBranchMatcherType;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.MinimalRef;
import com.atlassian.bitbucket.repository.ref.restriction.AbstractRefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import jakarta.annotation.Nonnull;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class ModelBranchMatcher
extends AbstractRefMatcher {
    private final boolean allowDisplayIdMatches;
    private final String currentRefId;
    private final String displayId;

    public ModelBranchMatcher(String branchType, String displayId, BranchModel model) {
        super((RefMatcherType)ModelBranchMatcherType.getInstance(), branchType);
        Branch production;
        this.displayId = displayId;
        this.currentRefId = "development".equals(branchType) ? model.getDevelopment().getId() : ("production".equals(branchType) ? ((production = model.getProduction()) == null ? null : production.getId()) : null);
        this.allowDisplayIdMatches = false;
    }

    public ModelBranchMatcher(String branchType, String displayId, BranchModelConfiguration modelConfiguration, String defaultBranch) {
        super((RefMatcherType)ModelBranchMatcherType.getInstance(), branchType);
        this.displayId = displayId;
        BranchConfiguration configuration = null;
        if ("development".equals(branchType)) {
            configuration = modelConfiguration.getDevelopment();
        } else if ("production".equals(branchType)) {
            configuration = modelConfiguration.getProduction();
        }
        this.currentRefId = configuration == null ? null : (String)ObjectUtils.firstNonNull((Object[])new String[]{configuration.getRefId(), configuration.isUseDefault() ? defaultBranch : null});
        this.allowDisplayIdMatches = true;
    }

    @Nonnull
    public String getDisplayId() {
        return this.displayId;
    }

    public boolean matches(@Nonnull MinimalRef ref) {
        return StringUtils.equals((CharSequence)ref.getId(), (CharSequence)this.currentRefId) || this.allowDisplayIdMatches && StringUtils.equals((CharSequence)ref.getDisplayId(), (CharSequence)this.currentRefId);
    }
}

