/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.restriction.provider;

import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.model.restriction.matcher.ModelBranchMatcher;
import com.atlassian.bitbucket.internal.branch.model.restriction.type.ModelBranchMatcherType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.EmptyRepositoryException;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.repository.ref.restriction.UnknownRefMatcher;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class ModelBranchMatcherProvider
implements RefMatcherProvider {
    private static final String MODEL_BRANCH = "MODEL_BRANCH";
    private static final String DEVELOPMENT_BRANCH = "development";
    private static final String PRODUCTION_BRANCH = "production";
    private final BranchModelService branchModelService;
    private final RepositoryService repositoryService;
    private final BranchModelConfigurationService branchModelConfigurationService;
    private final I18nService i18nService;
    private final EscalatedSecurityContext withProjectAdmin;

    public ModelBranchMatcherProvider(BranchModelService branchModelService, BranchModelConfigurationService branchModelConfigurationService, I18nService i18nService, SecurityService securityService, RepositoryService repositoryService) {
        this.branchModelService = branchModelService;
        this.repositoryService = repositoryService;
        this.branchModelConfigurationService = branchModelConfigurationService;
        this.i18nService = i18nService;
        this.withProjectAdmin = securityService.withPermission(Permission.PROJECT_ADMIN, "Ref restrictions");
    }

    @Nonnull
    public Optional<RefMatcher> create(@Nonnull Scope scope, final @Nonnull String value) {
        return (Optional)scope.accept((ScopeVisitor)new ScopeVisitor<Optional<RefMatcher>>(){

            public Optional<RefMatcher> visit(@Nonnull GlobalScope scope) {
                return Optional.empty();
            }

            public Optional<RefMatcher> visit(@Nonnull ProjectScope scope) {
                return Optional.of(ModelBranchMatcherProvider.this.createRefMatcher(value, scope));
            }

            public Optional<RefMatcher> visit(@Nonnull RepositoryScope scope) {
                return Optional.of(ModelBranchMatcherProvider.this.createRefMatcher(value, scope));
            }
        });
    }

    @Nonnull
    private RefMatcher createRefMatcher(@Nonnull String value, @Nonnull ProjectScope scope) {
        if (ModelBranchMatcherProvider.isUnknownBranch(value)) {
            return this.createUnknownMatcher(value);
        }
        return new ModelBranchMatcher(value, this.i18nService.getText("bitbucket.branchmodel." + value.toUpperCase(), value, new Object[0]), this.getBranchModelConfiguration((Scope)scope), null);
    }

    @Nonnull
    private RefMatcher createRefMatcher(@Nonnull String value, @Nonnull RepositoryScope scope) {
        if (ModelBranchMatcherProvider.isUnknownBranch(value)) {
            return this.createUnknownMatcher(value);
        }
        Repository repository = scope.getRepository();
        try {
            return new ModelBranchMatcher(value, this.i18nService.getText("bitbucket.branchmodel." + value.toUpperCase(), value, new Object[0]), this.branchModelService.getModel(repository));
        }
        catch (EmptyRepositoryException | NoDefaultBranchException e) {
            return new ModelBranchMatcher(value, this.i18nService.getText("bitbucket.branchmodel." + value.toUpperCase(), value, new Object[0]), this.getBranchModelConfiguration((Scope)scope), this.repositoryService.getDefaultBranch(repository).getId());
        }
    }

    @Nonnull
    private RefMatcher createUnknownMatcher(@Nonnull String value) {
        return new UnknownRefMatcher.Builder().matcherId(value).typeId(MODEL_BRANCH).build();
    }

    @Nonnull
    private BranchModelConfiguration getBranchModelConfiguration(@Nonnull Scope scope) {
        return (BranchModelConfiguration)this.withProjectAdmin.call(() -> this.branchModelConfigurationService.getConfiguration(scope));
    }

    @Nonnull
    public RefMatcherType getType() {
        return ModelBranchMatcherType.getInstance();
    }

    private static boolean isUnknownBranch(@Nonnull String value) {
        return !value.equals(DEVELOPMENT_BRANCH) && !value.equals(PRODUCTION_BRANCH);
    }
}

