/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.restriction.provider;

import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.internal.branch.model.restriction.matcher.ModelCategoryMatcher;
import com.atlassian.bitbucket.internal.branch.model.restriction.type.ModelCategoryMatcherType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcher;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherProvider;
import com.atlassian.bitbucket.repository.ref.restriction.RefMatcherType;
import com.atlassian.bitbucket.repository.ref.restriction.UnknownRefMatcher;
import com.atlassian.bitbucket.scope.GlobalScope;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.user.EscalatedSecurityContext;
import com.atlassian.bitbucket.user.SecurityService;
import jakarta.annotation.Nonnull;
import java.util.Optional;

public class ModelCategoryMatcherProvider
implements RefMatcherProvider {
    private static final String MODEL_CATEGORY = "MODEL_CATEGORY";
    private final BranchModelConfigurationService configurationService;
    private final EscalatedSecurityContext withProjectAdmin;
    private final EscalatedSecurityContext withRepoAdmin;

    public ModelCategoryMatcherProvider(BranchModelConfigurationService configurationService, SecurityService securityService) {
        this.configurationService = configurationService;
        this.withProjectAdmin = securityService.withPermission(Permission.PROJECT_ADMIN, "Ref restrictions");
        this.withRepoAdmin = securityService.withPermission(Permission.REPO_ADMIN, "Ref restrictions");
    }

    @Nonnull
    public Optional<RefMatcher> create(@Nonnull Scope scope, final @Nonnull String branchTypeId) {
        return (Optional)scope.accept((ScopeVisitor)new ScopeVisitor<Optional<RefMatcher>>(){

            public Optional<RefMatcher> visit(@Nonnull GlobalScope scope) {
                return Optional.empty();
            }

            public Optional<RefMatcher> visit(@Nonnull ProjectScope scope) {
                return (Optional)ModelCategoryMatcherProvider.this.withProjectAdmin.call(() -> ModelCategoryMatcherProvider.this.createRefMatcher((Scope)scope, branchTypeId));
            }

            public Optional<RefMatcher> visit(@Nonnull RepositoryScope scope) {
                return (Optional)ModelCategoryMatcherProvider.this.withRepoAdmin.call(() -> ModelCategoryMatcherProvider.this.createRefMatcher((Scope)scope, branchTypeId));
            }
        });
    }

    @Nonnull
    public RefMatcherType getType() {
        return ModelCategoryMatcherType.getInstance();
    }

    @Nonnull
    private Optional<RefMatcher> createRefMatcher(@Nonnull Scope scope, @Nonnull String branchTypeId) {
        BranchModelConfiguration configuration = this.configurationService.getConfiguration(scope);
        for (BranchTypeConfiguration type : configuration.getTypes()) {
            if (!type.isEnabled() || !branchTypeId.equals(type.getId())) continue;
            return Optional.of(new ModelCategoryMatcher(type));
        }
        return Optional.of(new UnknownRefMatcher.Builder().matcherId(branchTypeId).typeId(MODEL_CATEGORY).build());
    }
}

