/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.version;

import com.atlassian.bitbucket.internal.branch.model.exception.IllegalVersionStringException;
import com.atlassian.bitbucket.util.Chainable;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.commons.lang3.StringUtils;

public class BranchVersion
implements Comparable<BranchVersion> {
    private final String original;
    private final List<Component> components;
    private final int firstNumeric;

    private BranchVersion(String original, List<Component> components) {
        this.original = original;
        this.components = components;
        this.firstNumeric = this.findFirstNumeric();
        if (this.firstNumeric == -1) {
            throw new IllegalVersionStringException("'" + original + "' does not contain a version");
        }
    }

    @Nonnull
    public static BranchVersion parse(@Nonnull String versionString, @Nonnull String versionComponentSeparators) {
        Objects.requireNonNull(versionComponentSeparators, "versionComponentSeparators");
        Object[] components = Objects.requireNonNull(versionString, "versionString").split(versionComponentSeparators);
        return new BranchVersion(versionString, Chainable.chain((Object[])components).filter(StringUtils::isNotBlank).transform(Component.FROM_CONTENT).toList());
    }

    @Override
    public int compareTo(@Nonnull BranchVersion that) {
        if (!this.isCompatibleWith(that)) {
            throw new IllegalArgumentException(String.valueOf(this) + "is not compatible to " + String.valueOf(that));
        }
        int max = Math.min(this.components.size(), that.components.size());
        for (int i = this.firstNumeric; i < max; ++i) {
            int result = this.componentAt(i).compareTo(that.componentAt(i));
            if (result == 0) continue;
            return result;
        }
        int bySize = Integer.compare(this.components.size(), that.components.size());
        if (bySize != 0) {
            if (this.findComponentAt(max, that).isNumeric()) {
                return bySize;
            }
            return -bySize;
        }
        return this.original.compareTo(that.original);
    }

    @Nonnull
    public Predicate<BranchVersion> matcher() {
        return this::isCompatibleWith;
    }

    public boolean isCompatibleWith(@Nonnull BranchVersion that) {
        if (this.firstNumeric != that.firstNumeric) {
            return false;
        }
        int componentsToCompare = this.firstNumeric >= 0 ? this.firstNumeric : this.components.size();
        for (int i = 0; i < componentsToCompare; ++i) {
            if (this.componentAt(i).compareTo(that.componentAt(i)) == 0) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.original.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!this.getClass().equals(obj.getClass())) {
            return false;
        }
        BranchVersion that = (BranchVersion)obj;
        return this.original.equals(that.original);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("original", (Object)this.original).add("components", this.components).toString();
    }

    private int findFirstNumeric() {
        for (int i = 0; i < this.components.size(); ++i) {
            if (!this.components.get(i).isNumeric()) continue;
            return i;
        }
        return -1;
    }

    private Component componentAt(int i) {
        return this.components.get(i);
    }

    private Component findComponentAt(int i, BranchVersion that) {
        if (this.components.size() > i) {
            return this.componentAt(i);
        }
        return that.componentAt(i);
    }

    private static class Component
    implements Comparable<Component> {
        static final Function<String, Component> FROM_CONTENT = Component::new;
        private final String content;
        private final Integer numericContent;
        private final boolean isNumeric;

        private Component(@Nonnull String content) {
            Preconditions.checkArgument((boolean)StringUtils.isNotBlank((CharSequence)content), (Object)"Content cannot be blank");
            this.content = content;
            this.numericContent = this.parseNumeric(content);
            this.isNumeric = this.numericContent != null;
        }

        private Integer parseNumeric(String content) {
            try {
                return Integer.valueOf(content);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        boolean isNumeric() {
            return this.isNumeric;
        }

        @Override
        public int compareTo(@Nonnull Component that) {
            if (this.isNumeric && that.isNumeric) {
                return this.numericContent.compareTo(that.numericContent);
            }
            if (this.isNumeric) {
                return 1;
            }
            if (that.isNumeric) {
                return -1;
            }
            return this.content.compareTo(that.content);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!this.getClass().equals(obj.getClass())) {
                return false;
            }
            Component that = (Component)obj;
            return this.compareTo(that) == 0;
        }

        public int hashCode() {
            return this.content.hashCode();
        }

        public String toString() {
            return this.content;
        }
    }
}

