/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.version;

import com.atlassian.bitbucket.internal.branch.model.exception.IllegalVersionStringException;
import com.atlassian.bitbucket.internal.branch.model.version.BranchVersion;
import com.atlassian.bitbucket.repository.Branch;
import jakarta.annotation.Nonnull;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedBranch
implements Comparable<VersionedBranch> {
    public static final Function<VersionedBranch, Branch> TO_BRANCH = VersionedBranch::getBranch;
    private static final Logger log = LoggerFactory.getLogger(VersionedBranch.class);
    private final Branch branch;
    private final BranchVersion version;

    public VersionedBranch(@Nonnull Branch branch, @Nonnull BranchVersion version) {
        this.branch = Objects.requireNonNull(branch, "branch");
        this.version = Objects.requireNonNull(version, "version");
    }

    public static Function<Branch, Optional<VersionedBranch>> fromBranch(final String prefix, final @Nonnull String versionComponentSeparators) {
        return new Function<Branch, Optional<VersionedBranch>>(){

            @Override
            public Optional<VersionedBranch> apply(Branch branch) {
                try {
                    String version = branch.getDisplayId();
                    if (prefix != null) {
                        version = version.substring(prefix.length());
                    }
                    return Optional.of(new VersionedBranch(branch, BranchVersion.parse(version, versionComponentSeparators)));
                }
                catch (IllegalVersionStringException e) {
                    log.debug("Branch '{}' is not a VersionedBranch (error: '{}')", (Object)branch.getDisplayId(), (Object)e.getMessage());
                    return Optional.empty();
                }
            }
        };
    }

    @Nonnull
    public Branch getBranch() {
        return this.branch;
    }

    @Nonnull
    public BranchVersion getVersion() {
        return this.version;
    }

    @Nonnull
    public Predicate<VersionedBranch> isCompatible() {
        return that -> this.version.isCompatibleWith(that.version);
    }

    @Nonnull
    public Predicate<VersionedBranch> isGreater() {
        return this.isCompatible().and(that -> this.compareTo((VersionedBranch)that) < 0);
    }

    @Override
    public int compareTo(@Nonnull VersionedBranch that) {
        return this.version.compareTo(that.version);
    }
}

