/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.model.web;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.ForbiddenException;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.branch.model.configuration.BranchConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationException;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationRequest;
import com.atlassian.bitbucket.branch.model.configuration.BranchModelConfigurationService;
import com.atlassian.bitbucket.branch.model.configuration.BranchTypeConfiguration;
import com.atlassian.bitbucket.branch.model.configuration.SimpleBranchTypeConfiguration;
import com.atlassian.bitbucket.dmz.settingsrestriction.DmzProjectSettingsRestrictionService;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionState;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfiguration;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.cascadingmerge.configuration.CascadingMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationRequest;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.DeleteAfterMergeConfigurationService;
import com.atlassian.bitbucket.internal.branch.model.rest.RestBranchModelConfiguration;
import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.project.ProjectService;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.RefType;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.StandardRefType;
import com.atlassian.bitbucket.scope.ProjectScope;
import com.atlassian.bitbucket.scope.RepositoryScope;
import com.atlassian.bitbucket.scope.Scope;
import com.atlassian.bitbucket.scope.ScopeVisitor;
import com.atlassian.bitbucket.scope.Scopes;
import com.atlassian.bitbucket.server.Feature;
import com.atlassian.bitbucket.server.FeatureManager;
import com.atlassian.bitbucket.server.StandardFeature;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionAction;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessedState;
import com.atlassian.bitbucket.validation.ArgumentValidationException;
import com.atlassian.bitbucket.validation.FormErrors;
import com.atlassian.bitbucket.validation.SimpleFormErrors;
import com.atlassian.sal.api.xsrf.XsrfTokenAccessor;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;

@LicensedOnly
public class BranchModelSettingsServlet
extends HttpServlet {
    @VisibleForTesting
    static final String CASCADING_MERGE_FIELD_NAME = "branch-model-cascadingmerge-status";
    @VisibleForTesting
    static final String CASCADING_MERGE_MERGE_CHECK_FIELD_NAME = "branch-model-cascadingmerge-mergecheck";
    @VisibleForTesting
    static final String DELETE_AFTER_MERGE_FIELD_NAME = "branch-model-delete-after-merge";
    @VisibleForTesting
    static final String DEVELOPMENT_BRANCH_FIELD_NAME = "branch-model-development";
    @VisibleForTesting
    static final String DEVELOPMENT_REF_EXISTS = "developmentRefExists";
    @VisibleForTesting
    static final String ENFORCE_PROJECT_SETTINGS_FIELD_NAME = "branch-model-eps";
    @VisibleForTesting
    static final String INHERIT_FIELD_NAME = "inherit-settings-selection";
    @VisibleForTesting
    static final String PRODUCTION_BRANCH_FIELD_NAME = "branch-model-production";
    @VisibleForTesting
    static final String PRODUCTION_REF_EXISTS = "productionRefExists";
    private static final String DEFAULT_BRANCH_VALUE = "/USE_DEFAULT/";
    private static final String ENABLED_FIELD_SUFFIX = "-enabled";
    private static final String INHERIT_FIELD_VALUE = "INHERIT";
    private static final String PREFIX_FIELD_SUFFIX = "-prefix";
    private static final String PROJECTS = "projects";
    private static final String REPOS = "repos";
    private static final String REPOSITORY_SETTINGS_PAGE_CONTEXT = "bitbucket.page.branch.model.settings";
    private static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-branch:server-side-templates";
    private static final String TEMPLATE_KEY = "bitbucket.internal.page.settings.branchModelSettings.branchModelSettings.branchModelSettings";
    private static final String UPDATED_SESSION_KEY = "branchModelServlet-updated";
    private final BranchModelConfigurationService branchModelConfigurationService;
    private final CascadingMergeConfigurationService cascadingMergeConfigService;
    private final DeleteAfterMergeConfigurationService deleteAfterMergeConfigService;
    private final FeatureManager featureManager;
    private final I18nService i18nService;
    private final NavBuilder navBuilder;
    private final PageBuilderService pageBuilderService;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final ProjectService projectService;
    private final DmzProjectSettingsRestrictionService projectSettingsRestrictionService;
    private final RefService refService;
    private final RepositoryService repositoryService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final XsrfTokenAccessor xsrfTokenAccessor;
    private final XsrfTokenValidator xsrfTokenValidator;

    public BranchModelSettingsServlet(BranchModelConfigurationService branchModelService, CascadingMergeConfigurationService cascadingMergeConfigService, DeleteAfterMergeConfigurationService deleteAfterMergeConfigService, FeatureManager featureManager, I18nService i18nService, NavBuilder navBuilder, PageBuilderService pageBuilderService, PermissionService permissionService, PermissionValidationService permissionValidationService, DmzProjectSettingsRestrictionService projectSettingsRestrictionService, RefService refService, RepositoryService repositoryService, ProjectService projectService, SoyTemplateRenderer soyTemplateRenderer, XsrfTokenAccessor xsrfTokenAccessor, XsrfTokenValidator xsrfTokenValidator) {
        this.branchModelConfigurationService = branchModelService;
        this.cascadingMergeConfigService = cascadingMergeConfigService;
        this.deleteAfterMergeConfigService = deleteAfterMergeConfigService;
        this.featureManager = featureManager;
        this.i18nService = i18nService;
        this.navBuilder = navBuilder;
        this.pageBuilderService = pageBuilderService;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.projectSettingsRestrictionService = projectSettingsRestrictionService;
        this.refService = refService;
        this.repositoryService = repositoryService;
        this.projectService = projectService;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.xsrfTokenAccessor = xsrfTokenAccessor;
        this.xsrfTokenValidator = xsrfTokenValidator;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.permissionValidationService.validateAuthenticated();
        boolean updated = this.readUpdated(request);
        String[] pathParts = this.getPathParts(request);
        if (pathParts == null) {
            response.sendError(400);
            return;
        }
        Scope scope = this.getScope(pathParts);
        if (scope == null) {
            response.sendError(404);
            return;
        }
        this.prepareResponse((ServletResponse)response);
        this.doGetScope(request, response, scope, updated);
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.permissionValidationService.validateAuthenticated();
        if (this.xsrfTokenValidator.validateFormEncodedToken(request)) {
            String[] pathParts = this.getPathParts(request);
            if (pathParts == null) {
                response.sendError(400);
                return;
            }
            Scope scope = this.getScope(pathParts);
            if (scope == null) {
                response.sendError(404);
                return;
            }
            if (INHERIT_FIELD_VALUE.equals(request.getParameter(INHERIT_FIELD_NAME))) {
                this.branchModelConfigurationService.deleteConfiguration(scope);
                this.deleteAfterMergeConfigService.deleteConfiguration(scope);
                this.redirectToView(request, response);
            } else {
                try {
                    this.doPostActions(request, response, scope);
                }
                catch (ForbiddenException exception) {
                    response.sendError(401, exception.getLocalizedMessage());
                }
                catch (IllegalArgumentException exception) {
                    response.sendError(400, exception.getLocalizedMessage());
                }
            }
        } else {
            request.getRequestDispatcher(this.navBuilder.xsrfNotification().buildRelNoContext()).forward((ServletRequest)request, (ServletResponse)response);
        }
    }

    private Set<BranchTypeConfiguration> applyDisplayNamesFrom(BranchModelConfigurationRequest request, BranchModelConfiguration original) {
        ImmutableSet.Builder newTypes = ImmutableSet.builder();
        for (BranchTypeConfiguration typeConfiguration : request.getTypes()) {
            BranchTypes type = BranchTypes.forId(typeConfiguration.getId());
            BranchTypeConfiguration originalConfiguration = original.getTypes().stream().filter(type.matcher()).findFirst().orElse(null);
            if (originalConfiguration != null) {
                newTypes.add((Object)new SimpleBranchTypeConfiguration(type, originalConfiguration.getDisplayName(), typeConfiguration.isEnabled(), typeConfiguration.getPrefix()));
                continue;
            }
            newTypes.add((Object)typeConfiguration);
        }
        return newTypes.build();
    }

    private BranchModelConfigurationRequest buildBranchModelRequest(BranchModelConfiguration original, Scope scope, HttpServletRequest request) {
        BranchModelConfigurationRequest.Builder builder = new BranchModelConfigurationRequest.Builder(original).scope(scope);
        this.setDevelopment(builder, (ServletRequest)request);
        this.setProduction(builder, (ServletRequest)request);
        this.setTypes(original, (ServletRequest)request, builder);
        return builder.build();
    }

    private Map<String, Object> createViewContext(Scope scope, Map<String, Object> context, FormErrors errors, boolean cascadingMergeDisabled, boolean cascadingMergeOn, boolean cascadingMergeMergeCheckOn, boolean defaultDeleteBranchOn, boolean updated) {
        final ImmutableMap.Builder contextBuilder = ImmutableMap.builder();
        contextBuilder.putAll(context);
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope projectScope) {
                contextBuilder.put((Object)"project", (Object)projectScope.getProject());
                return null;
            }

            public Void visit(@Nonnull RepositoryScope repositoryScope) {
                Project project = repositoryScope.getProject();
                contextBuilder.put((Object)"project", (Object)project).put((Object)"repository", (Object)repositoryScope.getRepository());
                if (BranchModelSettingsServlet.this.permissionService.hasProjectPermission(project, Permission.PROJECT_ADMIN)) {
                    contextBuilder.put((Object)"projectSettingsUrl", (Object)BranchModelSettingsServlet.this.navBuilder.pluginServlets().path(new String[]{"branchmodel", BranchModelSettingsServlet.PROJECTS, project.getKey()}).buildRelative());
                }
                return null;
            }
        });
        contextBuilder.put((Object)"cascadingMerge", (Object)cascadingMergeOn).put((Object)"cascadingMergeMergeCheck", (Object)cascadingMergeMergeCheckOn).put((Object)"cascadingMergeDisabled", (Object)cascadingMergeDisabled).put((Object)"deleteSourceBranchDefault", (Object)defaultDeleteBranchOn).put((Object)"updated", (Object)updated);
        if (errors != null) {
            contextBuilder.put((Object)"errors", (Object)errors);
        }
        return contextBuilder.build();
    }

    private void doGetScope(HttpServletRequest request, HttpServletResponse response, Scope scope, boolean updated) throws ServletException, IOException {
        CascadingMergeConfiguration cascadingMergeConfiguration;
        BranchModelConfiguration configuration;
        try {
            configuration = this.branchModelConfigurationService.getConfiguration(scope);
            cascadingMergeConfiguration = this.cascadingMergeConfigService.getConfiguration(scope);
        }
        catch (ArgumentValidationException e) {
            response.sendError(400, e.getLocalizedMessage());
            return;
        }
        final ImmutableMap.Builder context = new ImmutableMap.Builder();
        context.put((Object)"branchModel", (Object)new RestBranchModelConfiguration(configuration));
        scope.accept((ScopeVisitor)new ScopeVisitor<Void>(){

            public Void visit(@Nonnull ProjectScope scope) {
                context.put((Object)"restriction", (Object)BranchModelSettingsServlet.this.projectSettingsRestrictionService.get(scope.getProject(), ProjectSettingsRestrictionKeys.BRANCH_MODEL).map(restriction -> ProjectSettingsRestrictionState.fromProcessedState((RestrictionProcessedState)restriction.getProcessedState())).orElse(ProjectSettingsRestrictionState.NONE));
                return null;
            }

            public Void visit(@Nonnull RepositoryScope scope) {
                Repository repository = scope.getRepository();
                context.put((Object)BranchModelSettingsServlet.DEVELOPMENT_REF_EXISTS, (Object)BranchModelSettingsServlet.this.hasExistingRefId(repository, configuration.getDevelopment()));
                context.put((Object)BranchModelSettingsServlet.PRODUCTION_REF_EXISTS, (Object)BranchModelSettingsServlet.this.hasExistingRefId(repository, configuration.getProduction()));
                context.put((Object)"restriction", (Object)BranchModelSettingsServlet.this.projectSettingsRestrictionService.get(scope.getProject(), ProjectSettingsRestrictionKeys.BRANCH_MODEL).map(restriction -> ProjectSettingsRestrictionState.fromProcessedState((RestrictionProcessedState)restriction.getProcessedState())).orElse(ProjectSettingsRestrictionState.NONE));
                return null;
            }
        });
        this.render(request, response, this.createViewContext(scope, (Map<String, Object>)context.build(), null, this.shouldDisableCascadingMerge(configuration), cascadingMergeConfiguration.isEnabled(), cascadingMergeConfiguration.isMergeCheckEnabled(), this.deleteAfterMergeConfigService.getConfiguration(scope).isEnabled(), updated));
    }

    private void doPostActions(HttpServletRequest request, HttpServletResponse response, Scope scope) throws IOException, ServletException {
        BranchModelConfiguration configuration = this.branchModelConfigurationService.getConfiguration(scope);
        BranchModelConfigurationRequest branchModelRequest = this.buildBranchModelRequest(configuration, scope, request);
        SimpleFormErrors.Builder errorsBuilder = new SimpleFormErrors.Builder();
        try {
            if (this.featureManager.isEnabled((Feature)StandardFeature.ENFORCE_PROJECT_SETTINGS)) {
                ProjectSettingsRestrictionAction restrictionAction = this.getProjectSettingsRestrictionAction(request, scope);
                configuration = (BranchModelConfiguration)this.projectSettingsRestrictionService.withRestriction(this.getProject(scope), ProjectSettingsRestrictionKeys.BRANCH_MODEL, restrictionAction, () -> this.branchModelConfigurationService.updateConfiguration(branchModelRequest));
            } else {
                configuration = this.branchModelConfigurationService.updateConfiguration(branchModelRequest);
            }
        }
        catch (BranchModelConfigurationException e) {
            for (String branchTypeId : e.getTypeIds()) {
                errorsBuilder.fieldError(branchTypeId, e.getLocalizedMessage());
            }
        }
        catch (ArgumentValidationException e) {
            errorsBuilder.formError(e.getLocalizedMessage());
        }
        ConfigurationResult configurationResult = new ConfigurationResult(configuration, (FormErrors)errorsBuilder.build());
        if (configurationResult.getErrors().isEmpty()) {
            this.cascadingMergeConfigService.setConfiguration(new CascadingMergeConfigurationRequest.Builder(scope).enabled(this.getCascadingMergeFromRequest((ServletRequest)request)).mergeCheckEnabled(this.getCascadingMergeMergeCheckFromRequest((ServletRequest)request)).build());
            this.deleteAfterMergeConfigService.setConfiguration(new DeleteAfterMergeConfigurationRequest(this.getDeleteAfterMergeFromRequest((ServletRequest)request), scope));
            this.redirectToView(request, response);
        } else {
            this.doViewAfterFailedUpdate(scope, branchModelRequest, configurationResult.getConfiguration(), configurationResult.getErrors(), request, response);
        }
    }

    private void doViewAfterFailedUpdate(Scope scope, BranchModelConfigurationRequest branchModelRequest, BranchModelConfiguration result, FormErrors errors, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.prepareResponse((ServletResponse)response);
        ImmutableMap context = ImmutableMap.of((Object)"branchModel", this.getBranchModelView(branchModelRequest, result, scope));
        this.render(request, response, this.createViewContext(scope, (Map<String, Object>)context, errors, this.shouldDisableCascadingMerge(branchModelRequest), this.getCascadingMergeFromRequest((ServletRequest)request), this.getCascadingMergeMergeCheckFromRequest((ServletRequest)request), this.getDeleteAfterMergeFromRequest((ServletRequest)request), false));
    }

    private boolean getCascadingMergeFromRequest(ServletRequest request) {
        return "ENABLED".equalsIgnoreCase(request.getParameter(CASCADING_MERGE_FIELD_NAME));
    }

    private boolean getCascadingMergeMergeCheckFromRequest(ServletRequest request) {
        return "ENABLED".equalsIgnoreCase(request.getParameter(CASCADING_MERGE_MERGE_CHECK_FIELD_NAME));
    }

    private Map<String, Object> getBranchModelView(BranchModelConfigurationRequest request, BranchModelConfiguration result, Scope scope) {
        ImmutableMap.Builder viewBuilder = ImmutableMap.builder().put((Object)"development", (Object)request.getDevelopment()).put((Object)"types", this.applyDisplayNamesFrom(request, result)).put((Object)"scope", (Object)scope);
        BranchConfiguration production = request.getProduction();
        if (production != null) {
            viewBuilder.put((Object)"production", (Object)production);
        }
        return viewBuilder.build();
    }

    private boolean getDeleteAfterMergeFromRequest(ServletRequest request) {
        return "ENABLED".equalsIgnoreCase(request.getParameter(DELETE_AFTER_MERGE_FIELD_NAME));
    }

    private boolean getEnabledParameter(BranchTypes type, ServletRequest request) {
        return BooleanUtils.toBoolean((String)request.getParameter(type.getId() + ENABLED_FIELD_SUFFIX));
    }

    private Map<String, Object> getInjectedData(HttpServletRequest req, HttpServletResponse resp) {
        return ImmutableMap.of((Object)"xsrfTokenName", (Object)this.xsrfTokenValidator.getXsrfParameterName(), (Object)"xsrfTokenValue", (Object)this.xsrfTokenAccessor.getXsrfToken(req, resp, true));
    }

    @Nullable
    private String[] getPathParts(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (Strings.isNullOrEmpty((String)pathInfo) || "/".equals(pathInfo)) {
            return null;
        }
        return pathInfo.substring(1).split("/");
    }

    private String getPrefixParameter(BranchTypes type, ServletRequest request) {
        return request.getParameter(type.getId() + PREFIX_FIELD_SUFFIX);
    }

    private Project getProject(Scope scope) {
        return (Project)scope.accept((ScopeVisitor)new ScopeVisitor<Project>(this){

            public Project visit(@Nonnull ProjectScope scope) {
                return scope.getProject();
            }

            public Project visit(@Nonnull RepositoryScope scope) {
                return scope.getProject();
            }
        });
    }

    private Project getProject(String[] pathParts) {
        return this.projectService.getByKey(pathParts[1]);
    }

    private ProjectSettingsRestrictionAction getProjectSettingsRestrictionAction(HttpServletRequest request, Scope scope) {
        final String value = StringUtils.trimToNull((String)request.getParameter(ENFORCE_PROJECT_SETTINGS_FIELD_NAME));
        return (ProjectSettingsRestrictionAction)scope.accept((ScopeVisitor)new ScopeVisitor<ProjectSettingsRestrictionAction>(){

            public ProjectSettingsRestrictionAction visit(@Nonnull ProjectScope scope) {
                if (value == null) {
                    throw new IllegalArgumentException(BranchModelSettingsServlet.this.i18nService.getMessage("bitbucket.branchmodel.error.epsfieldmissing", new Object[0]));
                }
                return Boolean.parseBoolean(value) ? ProjectSettingsRestrictionAction.CREATE : ProjectSettingsRestrictionAction.DELETE;
            }

            public ProjectSettingsRestrictionAction visit(@Nonnull RepositoryScope scope) {
                if (Boolean.parseBoolean(value)) {
                    throw new IllegalArgumentException(BranchModelSettingsServlet.this.i18nService.getMessage("bitbucket.branchmodel.error.cannotenableeps", new Object[0]));
                }
                return ProjectSettingsRestrictionAction.NONE;
            }
        });
    }

    private Repository getRepository(String[] pathParts) {
        return this.repositoryService.getBySlug(pathParts[1], pathParts[3]);
    }

    @Nullable
    private Scope getScope(@Nonnull String[] pathParts) {
        if (this.isProjectPath(pathParts)) {
            Project project = this.getProject(pathParts);
            return project == null ? null : Scopes.project((Project)project);
        }
        if (this.isRepoPath(pathParts)) {
            Repository repo = this.getRepository(pathParts);
            return repo == null ? null : Scopes.repository((Repository)repo);
        }
        return null;
    }

    private void handleSoyError(SoyException e) throws IOException, ServletException {
        Throwable cause = e.getCause();
        if (cause instanceof IOException) {
            throw (IOException)cause;
        }
        throw new ServletException((Throwable)e);
    }

    private boolean hasExistingRefId(Repository repository, BranchConfiguration configuration) {
        if (configuration != null && !configuration.isUseDefault()) {
            String devRefId = configuration.getRefId();
            return devRefId == null || this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(devRefId).type((RefType)StandardRefType.BRANCH).build()) != null;
        }
        return true;
    }

    private boolean hasNoReleaseBranches(BranchModelConfiguration branchModel) {
        return branchModel.getTypes().stream().noneMatch(branchTypeConfiguration -> branchTypeConfiguration.isEnabled() && BranchTypes.forId(branchTypeConfiguration.getId()) == BranchTypes.RELEASE);
    }

    private boolean isProjectPath(String[] pathParts) {
        return pathParts.length == 2 && PROJECTS.equals(pathParts[0]);
    }

    private boolean isRepoPath(String[] pathParts) {
        return pathParts.length == 4 && PROJECTS.equals(pathParts[0]) && REPOS.equals(pathParts[2]);
    }

    private void prepareResponse(ServletResponse response) {
        this.pageBuilderService.assembler().resources().requireContext(REPOSITORY_SETTINGS_PAGE_CONTEXT);
        response.setContentType("text/html;charset=UTF-8");
    }

    private boolean readUpdated(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        boolean updated = false;
        if (session != null) {
            updated = Boolean.TRUE.equals(session.getAttribute(UPDATED_SESSION_KEY));
            session.removeAttribute(UPDATED_SESSION_KEY);
        }
        return updated;
    }

    private void redirectToView(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.getSession().setAttribute(UPDATED_SESSION_KEY, (Object)true);
        response.sendRedirect(request.getRequestURI());
    }

    private void render(HttpServletRequest request, HttpServletResponse response, Map<String, Object> context) throws ServletException, IOException {
        try {
            this.soyTemplateRenderer.render((Appendable)response.getWriter(), RESOURCE_KEY, TEMPLATE_KEY, context, this.getInjectedData(request, response));
        }
        catch (SoyException soyException) {
            this.handleSoyError(soyException);
        }
    }

    private void setDevelopment(BranchModelConfigurationRequest.Builder updateRequestBuilder, ServletRequest request) {
        String developmentValue = StringUtils.trimToNull((String)request.getParameter(DEVELOPMENT_BRANCH_FIELD_NAME));
        if (developmentValue == null || DEFAULT_BRANCH_VALUE.equals(developmentValue)) {
            updateRequestBuilder.developmentRefId(null);
            updateRequestBuilder.useDefaultAsDevelopment(true);
        } else {
            updateRequestBuilder.developmentRefId(developmentValue);
            updateRequestBuilder.useDefaultAsDevelopment(false);
        }
    }

    private void setProduction(BranchModelConfigurationRequest.Builder updateRequestBuilder, ServletRequest request) {
        String productionValue = StringUtils.trimToNull((String)request.getParameter(PRODUCTION_BRANCH_FIELD_NAME));
        updateRequestBuilder.useDefaultAsProduction(DEFAULT_BRANCH_VALUE.equals(productionValue));
        if (productionValue == null || DEFAULT_BRANCH_VALUE.equals(productionValue)) {
            updateRequestBuilder.productionRefId(null);
        } else {
            updateRequestBuilder.productionRefId(productionValue);
        }
    }

    private void setTypes(BranchModelConfiguration original, ServletRequest request, BranchModelConfigurationRequest.Builder builder) {
        for (BranchTypes type : BranchTypes.values()) {
            String prefix = this.getPrefixParameter(type, request);
            boolean enabled = this.getEnabledParameter(type, request);
            if (!enabled && prefix == null) {
                BranchTypeConfiguration existingConfiguration = original.getTypes().stream().filter(type.matcher()).findFirst().orElse(null);
                prefix = existingConfiguration != null ? existingConfiguration.getPrefix() : null;
            }
            builder.type(type.getId(), prefix, enabled);
        }
    }

    private boolean shouldDisableCascadingMerge(BranchModelConfiguration branchModel) {
        return branchModel == null || branchModel.getProduction() == null && this.hasNoReleaseBranches(branchModel);
    }

    @VisibleForTesting
    static class ConfigurationResult {
        private final BranchModelConfiguration configuration;
        private final FormErrors errors;

        ConfigurationResult(BranchModelConfiguration configuration, FormErrors errors) {
            this.configuration = configuration;
            this.errors = errors;
        }

        BranchModelConfiguration getConfiguration() {
            return this.configuration;
        }

        FormErrors getErrors() {
            return this.errors;
        }
    }
}

