/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestConflictingRefNameMessage;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestDuplicateRefMessage;
import com.atlassian.bitbucket.dmz.rest.v2.repository.RestInvalidRefNameMessage;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.BranchHasMovedException;
import com.atlassian.bitbucket.internal.branch.ForbiddenBranchException;
import com.atlassian.bitbucket.internal.branch.InternalBranchService;
import com.atlassian.bitbucket.internal.branch.UnsupportedOnBranchException;
import com.atlassian.bitbucket.internal.branch.rest.RestBranchCreateRequest;
import com.atlassian.bitbucket.internal.branch.rest.RestBranchDeleteRequest;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.ConflictingRefNameException;
import com.atlassian.bitbucket.repository.DuplicateRefException;
import com.atlassian.bitbucket.repository.InvalidRefNameException;
import com.atlassian.bitbucket.rest.v2.api.RestErrorMessage;
import com.atlassian.bitbucket.rest.v2.api.RestErrors;
import com.atlassian.bitbucket.rest.v2.api.repository.RestBranch;
import com.atlassian.bitbucket.rest.v2.api.repository.RestMinimalRef;
import com.atlassian.bitbucket.rest.v2.api.resolver.PageRequestResolver;
import com.atlassian.bitbucket.rest.v2.api.resolver.RepositoryResolver;
import com.atlassian.bitbucket.rest.v2.api.util.ResponseFactory;
import com.atlassian.bitbucket.rest.v2.api.util.RestPage;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.dc.swagger.annotations.PathParamDoc;
import com.atlassian.dc.swagger.annotations.PathParamDocs;
import com.atlassian.dc.swagger.annotations.ResponseDoc;
import com.atlassian.dc.swagger.annotations.ResponseDocs;
import com.atlassian.plugins.rest.api.security.annotation.AnonymousSiteAccess;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.Parameters;
import io.swagger.v3.oas.annotations.enums.ParameterIn;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.parameters.RequestBody;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.BeanParam;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.DELETE;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;

@PathParamDocs(value={@PathParamDoc(name="projectKey", documentation="The project key."), @PathParamDoc(name="repositorySlug", documentation="The repository slug.")})
@Path(value="projects/{projectKey}/repos/{repositorySlug}/branches")
@Consumes(value={"application/json"})
@Produces(value={"application/json;charset=UTF-8"})
@Singleton
@AnonymousSiteAccess
@Tag(name="Repository")
public class BranchUtilsResource {
    private final InternalBranchService branchService;
    private final I18nService i18nService;

    @Inject
    public BranchUtilsResource(InternalBranchService branchService, I18nService i18nService) {
        this.branchService = branchService;
        this.i18nService = i18nService;
    }

    @Operation(description=" Creates a branch in the specified repository.\n\n\nThe authenticated user must have an effective <strong>REPO_WRITE</strong> permission to call this resource. If\nbranch permissions are set up in the repository, the authenticated user must also have access to the branch name\nthat is to be created.", summary="Create branch")
    @ResponseDocs(value={@ResponseDoc(documentation="JSON representation of the newly created branch", representation=RestBranch.class, responseCode=201), @ResponseDoc(documentation="The branch was not created because the request was invalid, e.g. the provided\nref name already existed in the repository, or was not a valid ref name in the\nrepository", responseCode=400, restError=true), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to create a branch. This could be due to insufficient repository permissions, or lack of branch permission for the provided ref name", responseCode=401, restError=true), @ResponseDoc(documentation="The branch name overlapped with an existing branch", responseCode=409, restError=true)})
    @RequestBody(content={@Content(schema=@Schema(implementation=RestBranchCreateRequest.class))}, required=true)
    @POST
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response createBranch(@BeanParam RepositoryResolver repositoryResolver, RestBranchCreateRequest restBranchCreateRequest) {
        Response response;
        if (StringUtils.isBlank((CharSequence)restBranchCreateRequest.getName())) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.branch.creation.name.empty", new Object[0])).build();
        }
        if (StringUtils.isBlank((CharSequence)restBranchCreateRequest.getStartPoint())) {
            return ResponseFactory.badRequest((String)this.i18nService.getMessage("bitbucket.branch.creation.startPoint.empty", new Object[0])).build();
        }
        try {
            Branch branch = this.branchService.createBranch(repositoryResolver.getRepository(), restBranchCreateRequest.getName(), restBranchCreateRequest.getStartPoint());
            response = ResponseFactory.status((Response.Status)Response.Status.CREATED).entity((Object)new RestBranch(branch)).build();
        }
        catch (ForbiddenBranchException e) {
            response = this.newErrorResponse(Response.Status.UNAUTHORIZED, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (DuplicateRefException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, (RestErrorMessage)new RestDuplicateRefMessage("name", e));
        }
        catch (ConflictingRefNameException e) {
            response = this.newErrorResponse(Response.Status.CONFLICT, (RestErrorMessage)new RestConflictingRefNameMessage("name", e));
        }
        catch (InvalidRefNameException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, (RestErrorMessage)new RestInvalidRefNameMessage("name", e));
        }
        return response;
    }

    @Operation(description=" Deletes a branch in the specified repository.\n\n\n If the branch does not exist, this operation will not raise an error. In other words after calling this resource\n and receiving a 204 response the branch provided in the request is guaranteed to not exist in the specified\n repository any more, regardless of its existence beforehand.\n\n\n The optional 'endPoint' parameter of the request may contain a commit ID that the provided ref name is\n expected to point to. Should the ref point to a different commit ID, a 400 response will be returned with\n appropriate error details.\n\n\n The authenticated user must have an effective <strong>REPO_WRITE</strong> permission to call this resource. If\n branch permissions are set up in the repository, the authenticated user must also have access to the branch name\n that is to be deleted.", summary="Delete branch")
    @ResponseDocs(value={@ResponseDoc(documentation="An empty response indicating that the branch no longer exists in the repository", responseCode=204), @ResponseDoc(documentation="The branch was not deleted because the request was invalid, e.g. no ref name\nto delete was provided, or the provided ref name points to the default branch\nin the repository that cannot be deleted", restError=true, responseCode=400), @ResponseDoc(documentation="The currently authenticated user has insufficient permissions to delete a\nbranch. This could be due to insufficient repository permissions, or lack of\nbranch permission for the provided ref name.", restError=true, responseCode=401)})
    @RequestBody(description="Branch delete request", content={@Content(schema=@Schema(implementation=RestBranchDeleteRequest.class))})
    @DELETE
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response deleteBranch(@BeanParam RepositoryResolver repositoryResolver, RestBranchDeleteRequest restBranchDeleteRequest) {
        Response response;
        try {
            this.branchService.deleteBranch(repositoryResolver.getRepository(), restBranchDeleteRequest.getName(), restBranchDeleteRequest.getEndPoint(), restBranchDeleteRequest.isDryRun());
            response = ResponseFactory.noContent().build();
        }
        catch (ForbiddenBranchException e) {
            response = this.newErrorResponse(Response.Status.UNAUTHORIZED, new RestErrorMessage("name", (Exception)((Object)e)));
        }
        catch (UnsupportedOnBranchException | InvalidRefNameException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, new RestErrorMessage("name", (Exception)e));
        }
        catch (BranchHasMovedException e) {
            response = this.newErrorResponse(Response.Status.BAD_REQUEST, new RestErrorMessage("endPoint", (Exception)((Object)e)));
        }
        return response;
    }

    @Operation(description="Gets the branch information associated with a single commit from a given repository.", summary="Get branch")
    @ResponseDocs(value={@ResponseDoc(documentation="A page of branch refs associated with the commit", paged=true, representation=RestMinimalRef.class, responseCode=200), @ResponseDoc(documentation="The request has timed out processing the branch request", restError=true, responseCode=500)})
    @Parameters(value={@Parameter(name="commitId", in=ParameterIn.PATH, content={@Content(schema=@Schema(maxLength=40))})})
    @GET
    @Path(value="info/{commitId}")
    @ScopesAllowed(requiredScope={"PUBLIC_REPOS"})
    public Response findByCommit(@BeanParam RepositoryResolver repositoryResolver, @BeanParam PageRequestResolver pageRequestResolver, @Parameter(hidden=true) @PathParam(value="commitId") String commit) {
        Page<Branch> branches = this.branchService.findByCommit(repositoryResolver.getRepository(), commit, pageRequestResolver.getPageRequest());
        return ResponseFactory.ok((Object)new RestPage(branches, RestBranch.REST_TRANSFORM)).build();
    }

    private Response newErrorResponse(Response.Status status, RestErrorMessage error) {
        RestErrors restErrors = new RestErrors(error);
        return ResponseFactory.status((Response.Status)status).entity((Object)restErrors).build();
    }
}

