/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.restriction;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.dmz.settingsrestriction.ProjectSettingsRestrictionKeys;
import com.atlassian.bitbucket.internal.branch.deleteaftermerge.dao.DeleteAfterMergeConfigDao;
import com.atlassian.bitbucket.internal.branch.model.dao.BranchModelDao;
import com.atlassian.bitbucket.internal.branch.model.event.BranchConfigurationBulkDeletedEvent;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.settingsrestriction.ProjectSettingsRestrictionProcessor;
import com.atlassian.bitbucket.settingsrestriction.RestrictionProcessingRequest;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Timers;
import com.google.common.collect.ImmutableList;
import jakarta.annotation.Nonnull;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BranchModelRestrictionProcessor
implements ProjectSettingsRestrictionProcessor {
    private static final Logger log = LoggerFactory.getLogger(BranchModelRestrictionProcessor.class);
    private final ActiveObjects ao;
    private final BranchModelDao branchModelDao;
    private final DeleteAfterMergeConfigDao deleteAfterConfigDao;
    private final EventPublisher eventPublisher;

    public BranchModelRestrictionProcessor(ActiveObjects ao, BranchModelDao branchModelDao, DeleteAfterMergeConfigDao deleteAfterConfigDao, EventPublisher eventPublisher) {
        this.ao = ao;
        this.branchModelDao = branchModelDao;
        this.deleteAfterConfigDao = deleteAfterConfigDao;
        this.eventPublisher = eventPublisher;
    }

    @Nonnull
    public String getFeatureKey() {
        return ProjectSettingsRestrictionKeys.BRANCH_MODEL.getFeatureKey();
    }

    @Nonnull
    public String getNamespace() {
        return ProjectSettingsRestrictionKeys.BRANCH_MODEL.getNamespace();
    }

    public boolean process(@Nonnull RestrictionProcessingRequest processingRequest) {
        log.trace("Deleting repository branch configurations for request {}", (Object)processingRequest);
        if (processingRequest.getRepositories().isEmpty()) {
            log.trace("No repos to process {}", (Object)processingRequest);
            return true;
        }
        Project project = ((Repository)processingRequest.getRepositories().iterator().next()).getProject();
        List repositoryIds = (List)processingRequest.getRepositories().stream().map(Repository::getId).collect(ImmutableList.toImmutableList());
        try (Ticker ignored = Timers.timer((String)String.format("BranchModelRestrictionProcessor: Processing restrictions for %s repositories", repositoryIds.size())).start(new Object[]{project.getId()});){
            boolean bl = (Boolean)this.ao.executeInTransaction(() -> {
                this.branchModelDao.deleteAll(repositoryIds);
                this.deleteAfterConfigDao.deleteAll(repositoryIds);
                this.eventPublisher.publish((Object)new BranchConfigurationBulkDeletedEvent(this, project, repositoryIds.size()));
                return true;
            });
            return bl;
        }
    }
}

