/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.web;

import com.atlassian.bitbucket.branch.model.BranchModel;
import com.atlassian.bitbucket.branch.model.BranchModelService;
import com.atlassian.bitbucket.branch.model.BranchType;
import com.atlassian.bitbucket.branch.model.BranchTypes;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.internal.branch.model.InternalBranchType;
import com.atlassian.bitbucket.internal.branch.web.BranchNameFormatter;
import com.atlassian.bitbucket.internal.branch.web.ViewRef;
import com.atlassian.bitbucket.internal.branch.web.ViewRefType;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.project.NoSuchProjectException;
import com.atlassian.bitbucket.repository.Branch;
import com.atlassian.bitbucket.repository.NoDefaultBranchException;
import com.atlassian.bitbucket.repository.Ref;
import com.atlassian.bitbucket.repository.RefService;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.repository.RepositoryService;
import com.atlassian.bitbucket.repository.ResolveRefRequest;
import com.atlassian.bitbucket.repository.Tag;
import com.atlassian.bitbucket.user.RecentlyAccessedRepositoriesService;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.bitbucket.util.PageUtils;
import com.atlassian.integration.jira.JiraIssueUrlsRequest;
import com.atlassian.integration.jira.JiraService;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Ints;
import jakarta.annotation.Nonnull;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class BranchCreationData {
    static final String ISSUE_TYPE_BUG = "Bug";
    static final String ISSUE_TYPE_STORY = "Story";
    static final String ISSUE_TYPE_NEW_FEATURE = "New Feature";
    static final String PARAM_REPO_ID = "repoId";
    static final String PARAM_BRANCH_TYPE = "branchType";
    static final String PARAM_ISSUE_KEY = "issueKey";
    static final String PARAM_ISSUE_TYPE = "issueType";
    static final String PARAM_ISSUE_SUMMARY = "issueSummary";
    static final String PARAM_BRANCH_FROM = "branchFrom";
    static final String PARAM_BRANCH_NAME = "branchName";
    static final String PARAM_PROJECT_KEY = "projectKey";
    private static final int RECENT_REPO_PAGE_SIZE = 5;
    private static final int ISSUE_BRANCH_NAME_LIMIT = 100;
    private final BranchModelService branchModelService;
    private final CustomBranchType customBranchType = new CustomBranchType();
    private final I18nService i18nService;
    private final JiraService jiraService;
    private final PermissionService permissionService;
    private final RecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService;
    private final RefService refService;
    private final RepositoryService repositoryService;

    public BranchCreationData(BranchModelService branchModelService, I18nService i18nService, JiraService jiraService, PermissionService permissionService, RecentlyAccessedRepositoriesService recentlyAccessedRepositoriesService, RefService refService, RepositoryService repositoryService) {
        this.branchModelService = branchModelService;
        this.i18nService = i18nService;
        this.jiraService = jiraService;
        this.permissionService = permissionService;
        this.recentlyAccessedRepositoriesService = recentlyAccessedRepositoriesService;
        this.refService = refService;
        this.repositoryService = repositoryService;
    }

    public Map<String, Object> soyResults(HttpServletRequest request) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        List<Repository> recentRepositories = this.getRecentRepositories();
        data.put("recentRepositories", recentRepositories);
        Repository repository = this.getRepository(request);
        int prefixLength = 0;
        if (repository != null) {
            boolean repositoryEmpty = this.repositoryService.isEmpty(repository);
            if (!repositoryEmpty) {
                ViewRef refData = this.getRefData(repository, Optional.ofNullable(request.getParameter(PARAM_BRANCH_FROM)).map(Object::toString)).orElse(null);
                data.put("sourceRef", refData);
                List<BranchType> branchTypes = this.getBranchTypes(repository);
                data.put("branchTypes", branchTypes);
                BranchType branchType = this.getBranchType(Optional.ofNullable(request.getParameter(PARAM_BRANCH_TYPE)), Optional.ofNullable(request.getParameter(PARAM_ISSUE_TYPE)), branchTypes).orElse(this.customBranchType);
                data.put(PARAM_BRANCH_TYPE, branchType);
                if (branchType instanceof InternalBranchType) {
                    InternalBranchType internalBranchType = (InternalBranchType)branchType;
                    prefixLength = internalBranchType.getPrefix().length();
                }
            }
            data.put("repository", repository);
            data.put("repositoryEmpty", repositoryEmpty);
        }
        int maxBranchLength = 100 - prefixLength;
        String branchName = Optional.ofNullable(request.getParameter(PARAM_BRANCH_NAME)).orElseGet(() -> BranchNameFormatter.generateBranchNameFromIssue(Optional.ofNullable(request.getParameter(PARAM_ISSUE_KEY)), Optional.ofNullable(request.getParameter(PARAM_ISSUE_SUMMARY)), maxBranchLength).orElse(null));
        data.put(PARAM_BRANCH_NAME, branchName);
        Optional.ofNullable(request.getParameter(PARAM_ISSUE_KEY)).ifPresent(issueKey -> {
            data.put(PARAM_ISSUE_KEY, issueKey);
            this.getIssueUrl((String)issueKey, repository).ifPresent(issueUrl -> data.put("issueUrl", issueUrl));
        });
        return data;
    }

    private List<Repository> getRecentRepositories() {
        PageRequestImpl pageRequest = new PageRequestImpl(0, 5);
        return this.recentlyAccessedRepositoriesService.findByCurrentUser(Permission.REPO_WRITE, (PageRequest)pageRequest).stream().collect(Collectors.toList());
    }

    private Optional<Repository> getEntityLinkedRecentRepository(HttpServletRequest request) {
        String[] parameterValues = request.getParameterValues(PARAM_PROJECT_KEY);
        Optional<Object> repository = Optional.empty();
        if (parameterValues != null) {
            List<String> projectKeys = Arrays.asList(parameterValues);
            repository = PageUtils.toStream(pageRequest -> this.recentlyAccessedRepositoriesService.findByCurrentUser(Permission.REPO_WRITE, pageRequest), (int)50).filter(repo -> projectKeys.contains(repo.getProject().getKey())).findFirst();
            if (!repository.isPresent() && !projectKeys.isEmpty()) {
                try {
                    repository = this.repositoryService.findByProjectKey(projectKeys.get(0), PageUtils.newRequest((int)0, (int)1)).stream().findFirst();
                }
                catch (NoSuchProjectException ex) {
                    repository = Optional.empty();
                }
            }
        }
        return repository.isPresent() ? repository : this.getRecentRepositories().stream().findFirst();
    }

    private Repository getRepository(HttpServletRequest request) {
        String[] pathParts = this.getPathParts(request);
        if (pathParts.length == 5 && "projects".equals(pathParts[1]) && "repos".equals(pathParts[3])) {
            return this.getRepositoryFromPath(pathParts);
        }
        String repoId = request.getParameter(PARAM_REPO_ID);
        if (!StringUtils.isBlank((CharSequence)repoId)) {
            return this.getRepositoryFromRequest(repoId).orElse(null);
        }
        return this.getEntityLinkedRecentRepository(request).orElse(null);
    }

    private Repository getRepositoryFromPath(String[] pathParts) {
        String projectKey = pathParts[2];
        String repoSlug = pathParts[4];
        if (StringUtils.isBlank((CharSequence)projectKey) || StringUtils.isBlank((CharSequence)repoSlug)) {
            return null;
        }
        return this.repositoryService.getBySlug(projectKey, repoSlug);
    }

    private String[] getPathParts(HttpServletRequest request) {
        String pathInfo = request.getPathInfo();
        if (StringUtils.isBlank((CharSequence)pathInfo)) {
            return new String[0];
        }
        return pathInfo.split("/");
    }

    private Optional<Repository> getRepositoryFromRequest(String repoIdString) {
        return Optional.ofNullable(Ints.tryParse((String)repoIdString)).flatMap(id -> Optional.ofNullable(this.repositoryService.getById(id.intValue()))).filter(repo -> this.permissionService.hasRepositoryPermission(repo, Permission.REPO_WRITE));
    }

    private Optional<ViewRef> getRefData(Repository repository, Optional<String> branch) {
        Ref ref = branch.map(b -> this.refService.resolveRef(new ResolveRefRequest.Builder(repository).refId(b).build())).orElseGet(() -> this.getDefaultBranch(repository).orElse(null));
        return Optional.ofNullable(ref).map(this::toViewRef);
    }

    private Optional<Ref> getDefaultBranch(Repository repository) {
        return BranchCreationData.catchNoDefaultBranch(() -> this.refService.getDefaultBranch(repository));
    }

    private ViewRef toViewRef(Ref ref) {
        ViewRefType refType = this.getViewRefType(ref);
        return new ViewRef(ref.getId(), ref.getDisplayId(), false, refType, ref.getLatestCommit());
    }

    private ViewRefType getViewRefType(Ref ref) {
        if (ref instanceof Branch) {
            return new ViewRefType("branch", this.i18nService.getMessage("bitbucket.web.revisionref.branch.name", new Object[0]));
        }
        if (ref instanceof Tag) {
            return new ViewRefType("tag", this.i18nService.getMessage("bitbucket.web.revisionref.tag.name", new Object[0]));
        }
        return new ViewRefType("commit", this.i18nService.getMessage("bitbucket.web.revisionref.commit.name", new Object[0]));
    }

    private List<BranchType> getBranchTypes(Repository repository) {
        Optional<BranchModel> branchModel = BranchCreationData.catchNoDefaultBranch(() -> this.branchModelService.getModel(repository));
        if (!branchModel.isPresent()) {
            return Collections.emptyList();
        }
        return ImmutableList.builder().addAll(branchModel.get().getTypes()).add((Object)this.customBranchType).build();
    }

    private Optional<BranchType> getBranchType(Optional<String> preferredBranchType, Optional<String> issueType, List<BranchType> availableBranchTypes) {
        if (availableBranchTypes.isEmpty()) {
            return Optional.empty();
        }
        if (!preferredBranchType.isPresent() && issueType.isPresent()) {
            preferredBranchType = Optional.of(this.getBranchTypeIdFromIssueType(issueType.get()));
        }
        boolean isCustomBranchAvailable = availableBranchTypes.stream().anyMatch(availableType -> availableType.getId().equalsIgnoreCase(this.customBranchType.getId()));
        return preferredBranchType.map(preferredType -> availableBranchTypes.stream().filter(availableType -> availableType.getId().equalsIgnoreCase((String)preferredType)).findFirst()).orElse(isCustomBranchAvailable ? Optional.of(this.customBranchType) : Optional.empty());
    }

    private String getBranchTypeIdFromIssueType(String issueType) {
        if (ISSUE_TYPE_BUG.equalsIgnoreCase(issueType)) {
            return BranchTypes.BUGFIX.getId();
        }
        if (ISSUE_TYPE_STORY.equalsIgnoreCase(issueType) || ISSUE_TYPE_NEW_FEATURE.equalsIgnoreCase(issueType)) {
            return BranchTypes.FEATURE.getId();
        }
        return this.customBranchType.getId();
    }

    private Optional<String> getIssueUrl(String issueKey, Repository repository) {
        if (!this.jiraService.isLinked()) {
            return Optional.empty();
        }
        JiraIssueUrlsRequest request = ((JiraIssueUrlsRequest.Builder)((JiraIssueUrlsRequest.Builder)new JiraIssueUrlsRequest.Builder().issueKey(issueKey, new String[0])).entityKey(repository == null ? null : repository.getProject().getKey())).build();
        Map issueUrls = this.jiraService.getIssueUrls(request);
        return Optional.ofNullable((String)issueUrls.get(issueKey));
    }

    private static <A> Optional<A> catchNoDefaultBranch(Supplier<A> supplier) {
        try {
            return Optional.ofNullable(supplier.get());
        }
        catch (NoDefaultBranchException e) {
            return Optional.empty();
        }
    }

    private class CustomBranchType
    implements InternalBranchType {
        private CustomBranchType() {
        }

        @Override
        @Nonnull
        public String getPrefix() {
            return "";
        }

        @Override
        @Nonnull
        public String getId() {
            return "CUSTOM";
        }

        @Override
        @Nonnull
        public String getDisplayName() {
            return BranchCreationData.this.i18nService.getMessage("bitbucket.branchmodel.type.CUSTOM", new Object[0]);
        }
    }
}

