/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.web;

import com.atlassian.annotations.security.LicensedOnly;
import com.atlassian.bitbucket.internal.branch.web.BranchCreationData;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionService;
import com.atlassian.bitbucket.permission.PermissionValidationService;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;

@LicensedOnly
public class BranchCreationServlet
extends HttpServlet {
    static final String RESOURCE_KEY = "com.atlassian.bitbucket.server.bitbucket-branch:server-side-templates";
    static final String BRANCH_CREATION_TEMPLATE_KEY = "bitbucketPluginBranch.internal.feature.branch.branchCreation.page.branchCreationPage.branchCreation";
    static final String NO_ACCESS_TEMPLATE_KEY = "bitbucketPluginBranch.internal.feature.branch.branchCreation.page.branchCreationPage.branchCreationNoWriteAccess";
    private final BranchCreationData branchCreationData;
    private final PermissionService permissionService;
    private final PermissionValidationService permissionValidationService;
    private final SoyTemplateRenderer soyTemplateRenderer;

    public BranchCreationServlet(BranchCreationData branchCreationData, PermissionService permissionService, PermissionValidationService permissionValidationService, SoyTemplateRenderer soyTemplateRenderer) {
        this.branchCreationData = branchCreationData;
        this.permissionService = permissionService;
        this.permissionValidationService = permissionValidationService;
        this.soyTemplateRenderer = soyTemplateRenderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.permissionValidationService.validateAuthenticated();
        if (!this.permissionService.hasAnyUserPermission(Permission.REPO_WRITE)) {
            this.render(response, NO_ACCESS_TEMPLATE_KEY, Collections.emptyMap());
        } else {
            this.render(response, BRANCH_CREATION_TEMPLATE_KEY, this.branchCreationData.soyResults(request));
        }
    }

    private void render(HttpServletResponse resp, String templateName, Map<String, Object> data) throws IOException, ServletException {
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), RESOURCE_KEY, templateName, data);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }
}

