/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.web;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;

public class BranchNameFormatter {
    private BranchNameFormatter() {
    }

    public static Optional<String> generateBranchNameFromIssue(Optional<String> issueKey, Optional<String> issueSummary, int maxLength) {
        ArrayList<String> parts = new ArrayList<String>();
        issueKey.ifPresent(parts::add);
        issueSummary.ifPresent(summary -> Arrays.stream(summary.split("\\s+")).map(BranchNameFormatter::slugify).filter(StringUtils::isNotBlank).forEach(parts::add));
        if (parts.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(BranchNameFormatter.joinWithMax(parts, '-', maxLength));
    }

    private static String joinWithMax(Iterable<String> parts, char separator, int maxLength) {
        StringBuilder builder = new StringBuilder(maxLength);
        for (String part : parts) {
            int length = builder.length();
            if (length > 0) {
                if (length + (part.length() + 1) > maxLength) break;
                builder.append(separator);
            }
            builder.append(part);
        }
        return builder.toString();
    }

    private static String slugify(String name) {
        return StringUtils.strip((String)StringUtils.stripAccents((String)name).replaceAll("[^a-zA-Z\\-_0-9.]+", "-").replaceAll("\\.\\.", "").replaceAll("[.\\-]+$", "").toLowerCase(Locale.US), (String)"-");
    }
}

