/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.branch.web;

import com.atlassian.annotations.security.AnonymousSiteAccess;
import com.atlassian.bitbucket.internal.branch.web.MimeUtils;
import com.google.common.io.ByteStreams;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;

@AnonymousSiteAccess
public class IconServlet
extends HttpServlet {
    private static final String RESOURCE_PATH = "resource-path";
    private static final String DEFAULT_TYPE = "application/octet-stream";
    private String resourcePath = null;
    private String resourceContentType = null;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.resourcePath = this.getResourcePath(config);
        this.resourceContentType = MimeUtils.getContentType(this.resourcePath, DEFAULT_TYPE);
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        response.setContentType(this.resourceContentType);
        response.setHeader("Cache-Control", "max-age=" + TimeUnit.DAYS.toSeconds(28L));
        ServletOutputStream out = response.getOutputStream();
        try (InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream(this.resourcePath);){
            ByteStreams.copy((InputStream)inputStream, (OutputStream)out);
        }
    }

    private String getResourcePath(ServletConfig config) {
        String location = config.getInitParameter(RESOURCE_PATH);
        if (StringUtils.isBlank((CharSequence)location)) {
            throw new IllegalArgumentException("resource-path is not properly set.");
        }
        URL resource = ((Object)((Object)this)).getClass().getResource(location);
        if (resource == null) {
            throw new IllegalStateException(location + " could not be found");
        }
        return location;
    }
}

