/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.security.serialblocklist.velocity;

import com.atlassian.security.serialblocklist.BlocklistConfigurator;
import com.atlassian.security.serialblocklist.util.ClassUtil;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Predicate;
import org.apache.velocity.util.introspection.AbstractChainableUberspector;
import org.apache.velocity.util.introspection.Info;
import org.apache.velocity.util.introspection.VelMethod;
import org.apache.velocity.util.introspection.VelPropertyGet;
import org.apache.velocity.util.introspection.VelPropertySet;

public class BlocklistUberspector
extends AbstractChainableUberspector {
    private final Map<Class<?>, Boolean> blockedClassCache = Collections.synchronizedMap(new WeakHashMap());

    public void init() throws Exception {
        if (this.inner == null) {
            throw new IllegalStateException("The inner uberspector must be set");
        }
        super.init();
    }

    boolean checkObject(Object target) {
        return this.blockedClassCache.computeIfAbsent(this.resolveArrayClass(target.getClass()), obj -> ClassUtil.checkObjectClass((Object)target, BlocklistPredicateHolder.INSTANCE));
    }

    private Class<?> resolveArrayClass(Class<?> clazz) {
        return clazz.isArray() ? clazz.getComponentType() : clazz;
    }

    public VelMethod getMethod(Object obj, String method, Object[] args, Info info) throws Exception {
        if (this.checkObject(obj)) {
            return this.inner.getMethod(obj, method, args, info);
        }
        return null;
    }

    public VelPropertyGet getPropertyGet(Object obj, String identifier, Info i) throws Exception {
        if (this.checkObject(obj)) {
            return this.inner.getPropertyGet(obj, identifier, i);
        }
        return null;
    }

    public VelPropertySet getPropertySet(Object obj, String identifier, Object arg, Info i) throws Exception {
        if (this.checkObject(obj)) {
            return this.inner.getPropertySet(obj, identifier, arg, i);
        }
        return null;
    }

    public Iterator<?> getIterator(Object obj, Info i) throws Exception {
        if (this.checkObject(obj)) {
            return this.inner.getIterator(obj, i);
        }
        return null;
    }

    private static class BlocklistPredicateHolder {
        static final Predicate<Class<?>> INSTANCE = new BlocklistConfigurator().configure();

        private BlocklistPredicateHolder() {
        }
    }
}

