/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth.serviceprovider.internal.servlet;

import com.atlassian.oauth.serviceprovider.internal.servlet.TransactionException;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Objects;

public abstract class TransactionalServlet
extends HttpServlet {
    private final TransactionTemplate transactionTemplate;
    private final ServeInTransaction GET = this::doGetInTransaction;
    private final ServeInTransaction POST = this::doPostInTransaction;

    public TransactionalServlet(TransactionTemplate transactionTemplate) {
        this.transactionTemplate = Objects.requireNonNull(transactionTemplate, "transactionTemplate");
    }

    protected final void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serve(this.GET, request, response);
    }

    protected void doGetInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    protected final void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        this.serve(this.POST, request, response);
    }

    protected void doPostInTransaction(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
    }

    private void serve(ServeInTransaction inTransaction, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        try {
            this.transactionTemplate.execute(() -> {
                try {
                    inTransaction.serve(request, response);
                }
                catch (ServletException | IOException e) {
                    throw new TransactionException((Exception)e);
                }
                return null;
            });
        }
        catch (TransactionException e) {
            if (e.getCause() instanceof IOException) {
                throw (IOException)e.getCause();
            }
            throw (ServletException)e.getCause();
        }
    }

    private static interface ServeInTransaction {
        public void serve(HttpServletRequest var1, HttpServletResponse var2) throws IOException, ServletException;
    }
}

