/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bamboo.configuration.AdministrationConfigurationAccessor;
import com.atlassian.bamboo.user.BambooUserManager;
import com.atlassian.oauth2.provider.core.user.BambooUserProvider;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.data.themes.BambooCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.CustomThemeConfiguration;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BambooOnly;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={BambooOnly.class})
public class BambooProviderConfiguration {
    @Bean
    public ProductUserProvider bambooUserProvider(BambooUserManager bambooUserManager) {
        return new BambooUserProvider(bambooUserManager);
    }

    @Bean
    public ProductCustomThemeFactory bambooCustomThemeFactory(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        return new BambooCustomThemeFactory(administrationConfigurationAccessor);
    }

    @Bean
    public CustomThemeConfiguration customThemeConfiguration(AdministrationConfigurationAccessor administrationConfigurationAccessor) {
        return new CustomThemeConfiguration(new BambooCustomThemeFactory(administrationConfigurationAccessor));
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }
}

