/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.bitbucket.auth.AuthenticationService;
import com.atlassian.bitbucket.user.UserService;
import com.atlassian.oauth2.provider.core.authentication.BitbucketLogoutHandler;
import com.atlassian.oauth2.provider.core.authentication.LogoutHandler;
import com.atlassian.oauth2.provider.core.user.BitbucketUserProvider;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.data.themes.BitbucketCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.CustomThemeConfiguration;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.BitbucketOnly;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={BitbucketOnly.class})
public class BitbucketProviderConfiguration {
    @Bean
    public ProductUserProvider bitbucketUserProvider(UserService userService) {
        return new BitbucketUserProvider(userService);
    }

    @Bean
    public ProductCustomThemeFactory bitbucketCustomThemeFactory() {
        return new BitbucketCustomThemeFactory();
    }

    @Bean
    public LogoutHandler bitbucketLogoutHandler(AuthenticationService authenticationService) {
        return new BitbucketLogoutHandler(authenticationService);
    }

    @Bean
    public CustomThemeConfiguration customThemeConfiguration() {
        return new CustomThemeConfiguration(new BitbucketCustomThemeFactory());
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }
}

