/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.confluence.themes.ColourSchemeManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.oauth2.provider.core.user.ConfluenceUserProvider;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.data.themes.ConfluenceCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.CustomThemeConfiguration;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.ConfluenceOnly;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={ConfluenceOnly.class})
public class ConfluenceProviderConfiguration {
    @Bean
    public ProductUserProvider confluenceUserProvider(UserAccessor userAccessor) {
        return new ConfluenceUserProvider(userAccessor);
    }

    @Bean
    public ProductCustomThemeFactory confluenceCustomThemeFactory(ColourSchemeManager colourSchemeManager) {
        return new ConfluenceCustomThemeFactory(colourSchemeManager);
    }

    @Bean
    public CustomThemeConfiguration customThemeConfiguration(ColourSchemeManager colourSchemeManager) {
        return new CustomThemeConfiguration(new ConfluenceCustomThemeFactory(colourSchemeManager));
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }
}

