/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.service.authentication.CrowdApplicationAuthenticationService;
import com.atlassian.oauth2.provider.config.products.CrowdAuditLogMapper;
import com.atlassian.oauth2.provider.core.authentication.CrowdLogoutHandler;
import com.atlassian.oauth2.provider.core.authentication.LogoutHandler;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.core.user.SalUserProvider;
import com.atlassian.oauth2.provider.data.themes.CrowdCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.CrowdOnly;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={CrowdOnly.class})
public class CrowdProviderPluginConfiguration {
    @Bean
    public ProductUserProvider salUserProvider(UserManager userManager) {
        return new SalUserProvider(userManager);
    }

    @Bean
    public PropertyManager propertyManager() {
        return OsgiServices.importOsgiService(PropertyManager.class);
    }

    @Bean
    public ProductCustomThemeFactory crowdCustomThemeFactory(PropertyManager propertyManager, ApplicationProperties applicationProperties) {
        return new CrowdCustomThemeFactory(propertyManager, applicationProperties);
    }

    @Bean
    public AuditService auditService(CrowdAuditLogMapper auditLogMapper) {
        com.atlassian.crowd.manager.audit.AuditService auditService = OsgiServices.importOsgiService(com.atlassian.crowd.manager.audit.AuditService.class);
        return event -> auditService.saveAudit(auditLogMapper.mapToAuditLogChangeset(event));
    }

    @Bean
    public CrowdAuditLogMapper crowdAuditEventMapper(I18nResolver i18nResolver) {
        return new CrowdAuditLogMapper(i18nResolver);
    }

    @Bean
    public LogoutHandler logoutHandler() {
        return new CrowdLogoutHandler(OsgiServices.importOsgiService(CrowdApplicationAuthenticationService.class));
    }
}

