/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.jira.config.properties.ApplicationProperties;
import com.atlassian.jira.config.properties.LookAndFeelBean;
import com.atlassian.jira.user.UserKeyService;
import com.atlassian.jira.user.util.UserManager;
import com.atlassian.oauth2.provider.core.user.JiraUserProvider;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.data.themes.CustomThemeConfiguration;
import com.atlassian.oauth2.provider.data.themes.JiraCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.JiraOnly;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={JiraOnly.class})
public class JiraProviderConfiguration {
    @Bean
    public ProductUserProvider jiraUserProvider(UserKeyService userKeyService, UserManager userManager) {
        return new JiraUserProvider(userKeyService, userManager);
    }

    @Bean
    public ProductCustomThemeFactory jiraCustomThemeFactory(ApplicationProperties jiraApplicationProperties, LookAndFeelBean lookAndFeelBean) {
        return new JiraCustomThemeFactory(jiraApplicationProperties, lookAndFeelBean);
    }

    @Bean
    public CustomThemeConfiguration customThemeConfiguration(ApplicationProperties applicationProperties, LookAndFeelBean lookAndFeelBean) {
        return new CustomThemeConfiguration(new JiraCustomThemeFactory(applicationProperties, lookAndFeelBean));
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }
}

