/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.config.products;

import com.atlassian.audit.api.AuditService;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.oauth2.provider.core.user.SalUserProvider;
import com.atlassian.oauth2.provider.data.themes.CustomThemeConfiguration;
import com.atlassian.oauth2.provider.data.themes.ProductCustomThemeFactory;
import com.atlassian.oauth2.provider.data.themes.RefappCustomThemeFactory;
import com.atlassian.plugins.osgi.javaconfig.OsgiServices;
import com.atlassian.plugins.osgi.javaconfig.conditions.product.RefappOnly;
import com.atlassian.sal.api.user.UserManager;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

@Configuration
@Conditional(value={RefappOnly.class})
public class RefappProviderConfiguration {
    @Bean
    public ProductUserProvider salUserProvider(UserManager atlassianUserManager) {
        return new SalUserProvider(atlassianUserManager);
    }

    @Bean
    public ProductCustomThemeFactory refappCustomThemeFactory() {
        return new RefappCustomThemeFactory();
    }

    @Bean
    public CustomThemeConfiguration customThemeConfiguration() {
        return new CustomThemeConfiguration(new RefappCustomThemeFactory());
    }

    @Bean
    public AuditService auditService() {
        return OsgiServices.importOsgiService(AuditService.class);
    }
}

