/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.authorization;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.oauth2.common.IdGenerator;
import com.atlassian.oauth2.provider.api.pkce.CodeChallengeMethod;
import com.atlassian.oauth2.provider.api.pkce.PkceService;
import com.atlassian.oauth2.provider.core.authorization.Authorization;
import com.atlassian.oauth2.provider.core.authorization.AuthorizationFlowResult;
import com.atlassian.oauth2.provider.core.authorization.AuthorizationService;
import com.atlassian.oauth2.provider.core.authorization.TokenResponseErrorDescription;
import com.atlassian.oauth2.provider.core.authorization.dao.AuthorizationDao;
import com.atlassian.oauth2.provider.core.authorization.dao.AuthorizationEntity;
import com.atlassian.oauth2.provider.core.authorization.exception.AuthorizationCodeFlowException;
import com.atlassian.oauth2.provider.core.event.authorization.ClientAuthorizationEvent;
import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAuthorizationService
implements AuthorizationService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAuthorizationService.class);
    private static final Integer MAX_RETRIES = 5;
    private final IdGenerator codeGenerator;
    private final UserManager userManager;
    private final AuthorizationDao authorizationDao;
    private final PkceService pkceService;
    private final Clock clock;
    private final EventPublisher eventPublisher;

    public DefaultAuthorizationService(IdGenerator codeGenerator, UserManager userManager, AuthorizationDao authorizationDao, Clock clock, PkceService pkceService, EventPublisher eventPublisher) {
        this.codeGenerator = codeGenerator;
        this.userManager = userManager;
        this.authorizationDao = authorizationDao;
        this.clock = clock;
        this.pkceService = pkceService;
        this.eventPublisher = eventPublisher;
    }

    @Override
    @Nonnull
    public String startAuthorizationFlow(@Nonnull String clientId, @Nonnull String redirectUri, @Nonnull Set<Scope> scope, CodeChallengeMethod codeChallengeMethod, String codeChallenge) {
        return this.attemptSaveWithRetry(0, AuthorizationEntity.builder().clientId(clientId).redirectUri(redirectUri).userKey(this.userManager.getRemoteUserKey().getStringValue()).createdAt(this.clock.millis()).scopes(scope).codeChallengeMethod(codeChallengeMethod).codeChallenge(codeChallenge));
    }

    private String attemptSaveWithRetry(Integer failureCount, AuthorizationEntity.AuthorizationEntityBuilder authorizationBuilder) {
        if (failureCount >= MAX_RETRIES) {
            throw new AuthorizationCodeFlowException();
        }
        String code = this.codeGenerator.generate();
        AuthorizationEntity authorization = authorizationBuilder.authorizationCode(code).build();
        try {
            this.authorizationDao.save(authorization);
        }
        catch (Exception e) {
            logger.debug("Failed to create authorization. Retry [" + failureCount + "] of [" + MAX_RETRIES + "]", (Throwable)e);
            this.attemptSaveWithRetry(failureCount + 1, authorizationBuilder);
        }
        this.eventPublisher.publish((Object)new ClientAuthorizationEvent(authorization));
        return code;
    }

    @Override
    public AuthorizationFlowResult completeAuthorizationFlow(@Nonnull String clientId, @Nonnull String redirectUri, @Nonnull String code) {
        return this.authorizationDao.removeByCode(code).filter(this::isNotExpired).map(authorization -> {
            if (this.isNotEquals(clientId, authorization.getClientId())) {
                return AuthorizationFlowResult.failed(TokenResponseErrorDescription.INVALID_CLIENT_ID);
            }
            if (this.isNotEquals(redirectUri, authorization.getRedirectUri())) {
                return AuthorizationFlowResult.failed(TokenResponseErrorDescription.INVALID_REDIRECT_URI);
            }
            return AuthorizationFlowResult.success(authorization);
        }).orElse(AuthorizationFlowResult.failed(TokenResponseErrorDescription.INVALID_CODE));
    }

    @Override
    public Optional<Authorization> getAuthorization(@Nonnull String authorizationCode) {
        return this.authorizationDao.findByCode(authorizationCode);
    }

    @Override
    public void removeExpiredAuthorizations(@Nonnull Duration expiration) {
        this.authorizationDao.removeExpiredAuthorizationsAfter(expiration);
    }

    @Override
    public boolean isPkceEnabledForAuthorization(@Nonnull String authorizationCode) {
        return this.authorizationDao.findByCode(authorizationCode).map(authorization -> authorization.getCodeChallengeMethod() != null).orElse(false);
    }

    @Override
    public boolean isPkceCodeVerifierValidAgainstAuthorization(@Nonnull String codeVerifier, @Nonnull String authorizationCode) {
        return this.authorizationDao.findByCode(authorizationCode).map(authorization -> this.pkceService.isExpectedCodeChallengeGenerated(authorization.getCodeChallenge(), authorization.getCodeChallengeMethod(), codeVerifier)).orElse(false);
    }

    private boolean isNotExpired(Authorization authorization) {
        long expiryTime = this.clock.millis() + SystemProperty.MAX_AUTHORIZATION_CODE_LIFETIME.getValue().toMillis();
        return authorization.getCreatedAt() < expiryTime;
    }

    private <T> boolean isNotEquals(T obj1, T obj2) {
        return !Objects.equals(obj1, obj2);
    }
}

