/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.authorization.dao;

import com.atlassian.oauth2.provider.api.pkce.CodeChallengeMethod;
import com.atlassian.oauth2.provider.core.authorization.Authorization;
import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.base.Preconditions;
import jakarta.annotation.Nonnull;
import java.util.Set;

public class AuthorizationEntity
implements Authorization {
    @Nonnull
    private final String authorizationCode;
    @Nonnull
    private final String clientId;
    @Nonnull
    private final String redirectUri;
    @Nonnull
    private final String userKey;
    @Nonnull
    private final Long createdAt;
    @Nonnull
    private final Set<Scope> scopes;
    private final CodeChallengeMethod codeChallengeMethod;
    private final String codeChallenge;

    AuthorizationEntity(@Nonnull String authorizationCode, @Nonnull String clientId, @Nonnull String redirectUri, @Nonnull String userKey, @Nonnull Long createdAt, @Nonnull Set<Scope> scope, CodeChallengeMethod codeChallengeMethod, String codeChallenge) {
        this.authorizationCode = authorizationCode;
        this.clientId = clientId;
        this.redirectUri = redirectUri;
        this.userKey = userKey;
        this.createdAt = createdAt;
        this.scopes = scope;
        this.codeChallengeMethod = codeChallengeMethod;
        this.codeChallenge = codeChallenge;
    }

    public static AuthorizationEntityBuilder builder() {
        return new AuthorizationEntityBuilder();
    }

    @Override
    @Nonnull
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    @Override
    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Override
    @Nonnull
    public String getRedirectUri() {
        return this.redirectUri;
    }

    @Override
    @Nonnull
    public String getUserKey() {
        return this.userKey;
    }

    @Override
    @Nonnull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    @Override
    @Nonnull
    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Override
    public CodeChallengeMethod getCodeChallengeMethod() {
        return this.codeChallengeMethod;
    }

    @Override
    public String getCodeChallenge() {
        return this.codeChallenge;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthorizationEntity)) {
            return false;
        }
        AuthorizationEntity other = (AuthorizationEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$authorizationCode = this.getAuthorizationCode();
        String other$authorizationCode = other.getAuthorizationCode();
        if (this$authorizationCode == null ? other$authorizationCode != null : !this$authorizationCode.equals(other$authorizationCode)) {
            return false;
        }
        String this$clientId = this.getClientId();
        String other$clientId = other.getClientId();
        if (this$clientId == null ? other$clientId != null : !this$clientId.equals(other$clientId)) {
            return false;
        }
        String this$redirectUri = this.getRedirectUri();
        String other$redirectUri = other.getRedirectUri();
        if (this$redirectUri == null ? other$redirectUri != null : !this$redirectUri.equals(other$redirectUri)) {
            return false;
        }
        String this$userKey = this.getUserKey();
        String other$userKey = other.getUserKey();
        if (this$userKey == null ? other$userKey != null : !this$userKey.equals(other$userKey)) {
            return false;
        }
        Long this$createdAt = this.getCreatedAt();
        Long other$createdAt = other.getCreatedAt();
        if (this$createdAt == null ? other$createdAt != null : !((Object)this$createdAt).equals(other$createdAt)) {
            return false;
        }
        Set<Scope> this$scope = this.getScopes();
        Set<Scope> other$scope = other.getScopes();
        if (this$scope == null ? other$scope != null : !((Object)this$scope).equals(other$scope)) {
            return false;
        }
        CodeChallengeMethod this$codeChallengeMethod = this.getCodeChallengeMethod();
        CodeChallengeMethod other$codeChallengeMethod = other.getCodeChallengeMethod();
        if (this$codeChallengeMethod == null ? other$codeChallengeMethod != null : !this$codeChallengeMethod.equals(other$codeChallengeMethod)) {
            return false;
        }
        String this$codeChallenge = this.getCodeChallenge();
        String other$codeChallenge = other.getCodeChallenge();
        return !(this$codeChallenge == null ? other$codeChallenge != null : !this$codeChallenge.equals(other$codeChallenge));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthorizationEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $authorizationCode = this.getAuthorizationCode();
        result = result * 59 + ($authorizationCode == null ? 43 : $authorizationCode.hashCode());
        String $clientId = this.getClientId();
        result = result * 59 + ($clientId == null ? 43 : $clientId.hashCode());
        String $redirectUri = this.getRedirectUri();
        result = result * 59 + ($redirectUri == null ? 43 : $redirectUri.hashCode());
        String $userKey = this.getUserKey();
        result = result * 59 + ($userKey == null ? 43 : $userKey.hashCode());
        Long $createdAt = this.getCreatedAt();
        result = result * 59 + ($createdAt == null ? 43 : ((Object)$createdAt).hashCode());
        Set<Scope> $scope = this.getScopes();
        result = result * 59 + ($scope == null ? 43 : ((Object)$scope).hashCode());
        CodeChallengeMethod $codeChallengeMethod = this.getCodeChallengeMethod();
        result = result * 59 + ($codeChallengeMethod == null ? 43 : $codeChallengeMethod.hashCode());
        String $codeChallenge = this.getCodeChallenge();
        result = result * 59 + ($codeChallenge == null ? 43 : $codeChallenge.hashCode());
        return result;
    }

    public String toString() {
        return "AuthorizationEntity(authorizationCode=" + this.getAuthorizationCode() + ", clientId=" + this.getClientId() + ", redirectUri=" + this.getRedirectUri() + ", userKey=" + this.getUserKey() + ", createdAt=" + this.getCreatedAt() + ", scopes=" + String.valueOf(this.getScopes()) + ", codeChallengeMethod=" + String.valueOf(this.getCodeChallengeMethod()) + ", codeChallenge=" + this.getCodeChallenge() + ")";
    }

    public static class AuthorizationEntityBuilder {
        private String authorizationCode;
        private String clientId;
        private String redirectUri;
        private String userKey;
        private Long createdAt;
        private Set<Scope> scopes;
        private CodeChallengeMethod codeChallengeMethod;
        private String codeChallenge;

        AuthorizationEntityBuilder() {
        }

        public AuthorizationEntityBuilder authorizationCode(@Nonnull String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public AuthorizationEntityBuilder clientId(@Nonnull String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AuthorizationEntityBuilder redirectUri(@Nonnull String redirectUri) {
            this.redirectUri = redirectUri;
            return this;
        }

        public AuthorizationEntityBuilder userKey(@Nonnull String userKey) {
            this.userKey = userKey;
            return this;
        }

        public AuthorizationEntityBuilder createdAt(@Nonnull Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public AuthorizationEntityBuilder scopes(@Nonnull Set<Scope> scope) {
            this.scopes = scope;
            return this;
        }

        public AuthorizationEntityBuilder codeChallengeMethod(CodeChallengeMethod codeChallengeMethod) {
            this.codeChallengeMethod = codeChallengeMethod;
            return this;
        }

        public AuthorizationEntityBuilder codeChallenge(String codeChallenge) {
            this.codeChallenge = codeChallenge;
            return this;
        }

        public AuthorizationEntity build() {
            Preconditions.checkNotNull((Object)this.authorizationCode, (Object)"authorizationCode cannot be null");
            Preconditions.checkNotNull((Object)this.clientId, (Object)"clientId cannot be null");
            Preconditions.checkNotNull((Object)this.redirectUri, (Object)"redirectUri cannot be null");
            Preconditions.checkNotNull((Object)this.userKey, (Object)"userKey cannot be null");
            Preconditions.checkNotNull((Object)this.createdAt, (Object)"createdAt cannot be null");
            Preconditions.checkNotNull(this.scopes, (Object)"scope cannot be null");
            return new AuthorizationEntity(this.authorizationCode, this.clientId, this.redirectUri, this.userKey, this.createdAt, this.scopes, this.codeChallengeMethod, this.codeChallenge);
        }

        public String toString() {
            return "AuthorizationEntity.AuthorizationEntityBuilder(authorizationCode=" + this.authorizationCode + ", clientId=" + this.clientId + ", redirectUri=" + this.redirectUri + ", userKey=" + this.userKey + ", createdAt=" + this.createdAt + ", scope=" + String.valueOf(this.scopes) + ", codeChallengeMethod=" + String.valueOf(this.codeChallengeMethod) + ", codeChallenge=" + this.codeChallenge + ")";
        }
    }
}

