/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client;

import com.atlassian.oauth2.client.api.storage.config.GrantType;
import com.atlassian.oauth2.common.IdGenerator;
import com.atlassian.oauth2.provider.api.client.Client;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.api.client.CreateClientEntity;
import com.atlassian.oauth2.provider.api.client.UpdateClientEntity;
import com.atlassian.oauth2.provider.api.token.FlowType;
import com.atlassian.oauth2.provider.core.client.dao.ClientDao;
import com.atlassian.oauth2.provider.core.client.dao.ClientEntity;
import com.atlassian.oauth2.provider.core.client.dao.RedirectUriDao;
import com.atlassian.oauth2.provider.core.client.util.ClientDateUtil;
import com.atlassian.oauth2.provider.core.credentials.ClientCredentialsGenerator;
import com.atlassian.oauth2.provider.core.event.OAuth2ProviderEventPublisher;
import com.atlassian.oauth2.provider.core.token.TokenService;
import com.atlassian.oauth2.provider.core.token.access.exception.UserKeyNotFoundException;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultClientService
implements ClientService {
    private static final Logger logger = LoggerFactory.getLogger(DefaultClientService.class);
    private final ClientDao clientDao;
    private final ClientCredentialsGenerator clientCredentialsGenerator;
    private final TokenService tokenService;
    private final UserManager userManager;
    private final I18nResolver i18nResolver;
    private final IdGenerator idGenerator;
    private final OAuth2ProviderEventPublisher oAuth2ProviderEventPublisher;
    private final RedirectUriDao redirectUriDao;

    public DefaultClientService(ClientDao clientDao, ClientCredentialsGenerator clientCredentialsGenerator, TokenService tokenService, UserManager userManager, I18nResolver i18nResolver, IdGenerator idGenerator, OAuth2ProviderEventPublisher oAuth2ProviderEventPublisher, RedirectUriDao redirectUriDao) {
        this.clientDao = clientDao;
        this.clientCredentialsGenerator = clientCredentialsGenerator;
        this.tokenService = tokenService;
        this.userManager = userManager;
        this.i18nResolver = i18nResolver;
        this.idGenerator = idGenerator;
        this.oAuth2ProviderEventPublisher = oAuth2ProviderEventPublisher;
        this.redirectUriDao = redirectUriDao;
    }

    @Nonnull
    public Client create(@Nonnull String name, @Nonnull Scope scope, @Nonnull List<String> redirectUris) {
        return this.create(new CreateClientEntity(name, scope, redirectUris, GrantType.CLIENT_DEFAULT_GRANT_TYPES, null));
    }

    @Nonnull
    public Client create(@Nonnull CreateClientEntity client) {
        if (DefaultClientService.isAuthCodeGrantType(client) && client.redirects().isEmpty()) {
            throw new IllegalStateException("Must contain at least one redirect uri");
        }
        Optional<UserKey> userKey = Optional.ofNullable(this.userManager.getRemoteUserKey());
        if (userKey.isPresent()) {
            Client newClient = this.clientDao.create(ClientEntity.builder().id(this.idGenerator.generate()).clientId(this.clientCredentialsGenerator.generate(ClientCredentialsGenerator.Length.THIRTY_TWO)).clientSecret(this.generateClientSecret()).scope(client.scope()).name(client.name()).userKey(userKey.get().getStringValue()).redirects(client.redirects()).supportedGrantTypes(client.supportedGrantTypes()).expiryDuration(client.expiryDuration()).createdDate(ClientDateUtil.nowInMillis()).build());
            this.oAuth2ProviderEventPublisher.publishClientConfigurationCreatedEvent(newClient);
            return newClient;
        }
        throw new UserKeyNotFoundException(this.i18nResolver.getText("oauth2.service.user.key.not.found"));
    }

    public Optional<Client> updateClient(@Nonnull String id, String name, String scope, @Nonnull List<String> redirectUris) {
        return this.updateClient(new UpdateClientEntity(id, name, scope, redirectUris, GrantType.CLIENT_DEFAULT_GRANT_TYPES, null));
    }

    public Optional<Client> updateClient(@Nonnull UpdateClientEntity client) {
        return this.clientDao.getById(client.id()).flatMap(oldClient -> this.clientDao.updateClient(client).map(newClient -> {
            this.oAuth2ProviderEventPublisher.publishClientConfigurationUpdatedEvent((Client)oldClient, (Client)newClient);
            return newClient;
        }));
    }

    public Optional<Client> resetClientSecret(@Nonnull String clientId) {
        return this.clientDao.resetClientSecret(clientId, this.generateClientSecret()).map(client -> {
            this.oAuth2ProviderEventPublisher.publishClientSecretRefreshedEvent((Client)client);
            return client;
        });
    }

    public Optional<Client> rotateClient(@Nonnull String clientId) {
        String newClientId = this.clientCredentialsGenerator.generate(ClientCredentialsGenerator.Length.THIRTY_TWO);
        String newClientSecret = this.generateClientSecret();
        return this.clientDao.rotateClient(clientId, newClientId, newClientSecret).map(client -> {
            this.oAuth2ProviderEventPublisher.publishClientRotatedEvent((Client)client);
            return client;
        });
    }

    public Optional<Client> getById(@Nonnull String id) {
        return this.clientDao.getById(id);
    }

    public Optional<Client> getByClientId(@Nonnull String clientId) {
        return this.clientDao.getByClientId(clientId);
    }

    public Optional<Client> getByRotatedClientId(@Nonnull String clientId) {
        return this.clientDao.getByRotatedClientId(clientId);
    }

    private Optional<Client> getByCurrentOrRotatedClientId(@Nonnull String clientId) {
        return this.getByClientId(clientId).or(() -> this.getByRotatedClientId(clientId));
    }

    public List<String> findRedirectUrisByClientId(@Nonnull String clientId) {
        return this.redirectUriDao.findByClientId(clientId);
    }

    public Optional<Client> removeById(@Nonnull String id) {
        Optional<Client> client = this.clientDao.removeById(id);
        client.ifPresent(it -> {
            this.oAuth2ProviderEventPublisher.publishClientConfigurationDeletedEvent((Client)it);
            this.tokenService.removeByClientId(it.getClientId());
        });
        return client;
    }

    public List<Client> list() {
        return this.clientDao.list();
    }

    public boolean isClientNameUnique(@Nullable String clientId, @Nonnull String clientName) {
        return this.clientDao.isClientNameUnique(clientId, clientName);
    }

    public boolean isClientValid(@Nonnull String clientId, @Nonnull String clientSecret, @Nonnull FlowType flowType) {
        Long createdDate;
        String storedClientSecret;
        Optional<Client> client = this.getByCurrentOrRotatedClientId(clientId);
        if (client.isEmpty()) {
            logger.debug("Client id '{}' not found.", (Object)clientId);
            return false;
        }
        Client entity = client.get();
        if (entity.getClientId().equals(clientId)) {
            storedClientSecret = entity.getClientSecret();
            createdDate = entity.getCreatedDate();
        } else if (entity.getRotatedClientId().equals(clientId)) {
            storedClientSecret = entity.getRotatedClientSecret();
            createdDate = entity.getRotatedCreatedDate();
        } else {
            logger.debug("Client id '{}' not found.", (Object)clientId);
            return false;
        }
        if (ClientDateUtil.hasExpired(createdDate, entity.getExpiryDuration())) {
            logger.debug("Client id '{}' has expired.", (Object)clientId);
            return false;
        }
        if (FlowType.PUBLIC_FLOWS.contains(flowType)) {
            logger.debug("Flow type '{}'", (Object)flowType);
            return true;
        }
        return clientSecret.equals(storedClientSecret);
    }

    public boolean isClientSecretValid(@Nonnull String clientId, @Nonnull String clientSecret) {
        return this.getByCurrentOrRotatedClientId(clientId).map(client -> DefaultClientService.isClientValid(clientId, clientSecret, client)).orElse(false);
    }

    public boolean isClientSecretValid(@Nonnull String clientId, @Nullable String clientSecret, @Nonnull FlowType flowType) {
        if (FlowType.PUBLIC_FLOWS.contains(flowType)) {
            return true;
        }
        return Optional.ofNullable(clientSecret).isPresent() && this.getByCurrentOrRotatedClientId(clientId).map(client -> DefaultClientService.isClientValid(clientId, clientSecret, client)).orElse(false) != false;
    }

    public Optional<Client> revokeRotatedClientSecret(@Nonnull String id) {
        return this.clientDao.revokeRotatedClientSecret(id).map(client -> {
            this.oAuth2ProviderEventPublisher.publishRotatedClientRevokedEvent((Client)client);
            return client;
        });
    }

    private static boolean isClientValid(@Nonnull String clientId, @Nonnull String clientSecret, Client client) {
        boolean currentClientValid;
        Client entity = client;
        boolean bl = currentClientValid = client.getClientId().equals(clientId) && client.getClientSecret().equals(clientSecret);
        if (currentClientValid) {
            return true;
        }
        return entity.getRotatedClientId() != null && entity.getRotatedClientId().equals(clientId) && entity.getRotatedClientSecret() != null && entity.getRotatedClientSecret().equals(clientSecret);
    }

    private String generateClientSecret() {
        return this.clientCredentialsGenerator.generate(ClientCredentialsGenerator.Length.SIXTY_FOUR);
    }

    private static boolean isAuthCodeGrantType(@Nonnull CreateClientEntity client) {
        return client.supportedGrantTypes() == null || client.supportedGrantTypes().contains(GrantType.AUTHORIZATION_CODE_GRANT);
    }
}

