/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.client.dao.entity;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.activeobjects.external.ActiveObjectsUpgradeTask;
import com.atlassian.activeobjects.external.ModelVersion;
import com.atlassian.oauth2.provider.core.client.dao.entity.AOClient;
import com.atlassian.oauth2.provider.core.client.util.ClientDateUtil;
import com.google.common.base.Preconditions;
import java.util.concurrent.atomic.AtomicInteger;
import net.java.ao.Query;

public class AOClientPopulateCreatedAndExpiryDateUpgradeTask
implements ActiveObjectsUpgradeTask {
    public static final int PAGE_SIZE = 500;

    public ModelVersion getModelVersion() {
        return ModelVersion.valueOf((String)"1");
    }

    public void upgrade(ModelVersion currentVersion, ActiveObjects ao) {
        boolean fullPageRetrieved;
        Preconditions.checkState((boolean)currentVersion.isSame(ModelVersion.valueOf((String)"0")), (Object)"This task can only upgrade from version 0 to 1");
        ao.migrate(new Class[]{AOClient.class});
        AtomicInteger pageNumber = new AtomicInteger();
        pageNumber.set(0);
        while (fullPageRetrieved = ((Boolean)ao.executeInTransaction(() -> {
            AOClient[] existingClients;
            for (AOClient existingClient : existingClients = (AOClient[])ao.find(AOClient.class, Query.select().limit(500).offset(500 * pageNumber.get()))) {
                existingClient.setCreatedDate(ClientDateUtil.nowInMillis());
                existingClient.save();
            }
            pageNumber.set(pageNumber.get() + 1);
            return existingClients.length == 500;
        })).booleanValue()) {
        }
    }
}

