/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.settings;

import com.atlassian.annotations.VisibleForTesting;
import com.atlassian.beehive.ClusterLock;
import com.atlassian.beehive.ClusterLockService;
import com.atlassian.oauth2.provider.core.credentials.ClientCredentialsGenerator;
import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import com.atlassian.oauth2.provider.core.security.ProviderPluginSecretServicePath;
import com.atlassian.oauth2.provider.core.settings.ProviderSettingsDao;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.secrets.api.SecretService;
import com.atlassian.secrets.api.SecretServiceState;
import jakarta.annotation.Nonnull;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultProviderSettingsDao
implements ProviderSettingsDao {
    private static final Logger logger = LoggerFactory.getLogger(DefaultProviderSettingsDao.class);
    private static final ClientCredentialsGenerator.Length CREDENTIALS_LENGTH = ClientCredentialsGenerator.Length.SIXTY_FOUR;
    @VisibleForTesting
    static final String PROVIDER_SETTINGS_SERVICE_LOCK = "com.atlassian.plugins.oauth2.provider.settings.service.lock";
    private final PluginSettingsFactory pluginSettingsFactory;
    private final ClusterLockService clusterLockService;
    private final ClientCredentialsGenerator clientCredentialsGenerator;
    private final SecretService secretService;

    public DefaultProviderSettingsDao(PluginSettingsFactory pluginSettingsFactory, ClusterLockService clusterLockService, ClientCredentialsGenerator clientCredentialsGenerator, SecretService secretService) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.clusterLockService = clusterLockService;
        this.clientCredentialsGenerator = clientCredentialsGenerator;
        this.secretService = secretService;
    }

    @Override
    public void saveJwtSecret() {
        PluginSettings pluginSettings = this.pluginSettings();
        this.executeWithLock(() -> {
            if (this.isSecretServiceDisabled()) {
                if (pluginSettings.get(ProviderPluginSecretServicePath.jwtKeyPath()) == null) {
                    logger.warn("Warning: Secret service is disabled, generating a new unencrypted JWT secret.");
                    pluginSettings.put(ProviderPluginSecretServicePath.jwtKeyPath(), (Object)this.clientCredentialsGenerator.generate(CREDENTIALS_LENGTH));
                }
            } else if (this.secretService.get(ProviderPluginSecretServicePath.jwtKeyPath()).isEmpty()) {
                logger.debug("Secret service is enabled, generating an encrypted JWT secret.");
                pluginSettings.put(ProviderPluginSecretServicePath.jwtKeyPath(), (Object)"{ATL_SECURED}");
                this.secretService.put(ProviderPluginSecretServicePath.jwtKeyPath(), this.clientCredentialsGenerator.generate(CREDENTIALS_LENGTH));
            }
        });
    }

    private void executeWithLock(Runnable callback) throws InterruptedException {
        ClusterLock lock = this.clusterLockService.getLockForName(PROVIDER_SETTINGS_SERVICE_LOCK);
        if (lock.tryLock(SystemProperty.GLOBAL_CLUSTER_LOCK_TIMEOUT_SECONDS.getValue().intValue(), TimeUnit.SECONDS)) {
            try {
                callback.run();
            }
            finally {
                lock.unlock();
            }
        } else {
            throw new IllegalMonitorStateException("Unable to obtain lock");
        }
    }

    @Override
    public void resetJwtSecret() {
        logger.debug("Resetting JWT secret");
        PluginSettings pluginSettings = this.pluginSettings();
        this.executeWithLock(() -> {
            if (this.isSecretServiceDisabled()) {
                logger.warn("Warning: Secret service is disabled, resetting with an unencrypted JWT secret.");
                pluginSettings.put(ProviderPluginSecretServicePath.jwtKeyPath(), (Object)this.clientCredentialsGenerator.generate(CREDENTIALS_LENGTH));
            } else {
                logger.debug("Secret service is enabled, resetting with a secure JWT secret.");
                pluginSettings.put(ProviderPluginSecretServicePath.jwtKeyPath(), (Object)"{ATL_SECURED}");
                this.secretService.put(ProviderPluginSecretServicePath.jwtKeyPath(), this.clientCredentialsGenerator.generate(CREDENTIALS_LENGTH));
            }
        });
    }

    @Override
    public String getJwtSecret() {
        if (this.isSecretServiceDisabled()) {
            logger.warn("Warning: Secret service is disabled, returning unencrypted JWT secret.");
            Object jwtSecret = this.pluginSettings().get(ProviderPluginSecretServicePath.jwtKeyPath());
            if (jwtSecret == null) {
                logger.warn("JWT secret stored in database was null. You need to call saveJwtSecret first");
                throw new RuntimeException("Failed to get JWT secret: JWT secret stored in database was null. Please reset the configured JWT secret property");
            }
            if (jwtSecret.toString().equals("{ATL_SECURED}")) {
                throw new RuntimeException("Secret service is disabled but JWT secret has been marked as secured.");
            }
            return jwtSecret.toString();
        }
        return (String)this.secretService.get(ProviderPluginSecretServicePath.jwtKeyPath()).orElseThrow(() -> new RuntimeException("Failed to get JWT secret: Secret service returned empty. Please reset the configured JWT secret property"));
    }

    @Nonnull
    private PluginSettings pluginSettings() {
        return this.pluginSettingsFactory.createGlobalSettings();
    }

    private boolean isSecretServiceDisabled() {
        return SecretService.getState() == SecretServiceState.DISABLED;
    }
}

