/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.settings;

import com.atlassian.cache.CacheFactory;
import com.atlassian.cache.CacheSettingsBuilder;
import com.atlassian.cache.CachedReference;
import com.atlassian.oauth2.provider.core.settings.ProviderSettingsDao;
import com.atlassian.oauth2.provider.core.settings.ProviderSettingsService;

public class DefaultProviderSettingsService
implements ProviderSettingsService {
    private final ProviderSettingsDao providerSettingsDao;
    private final CachedReference<String> jwtSecret;

    public DefaultProviderSettingsService(ProviderSettingsDao providerSettingsDao, CacheFactory cacheFactory) {
        this.providerSettingsDao = providerSettingsDao;
        this.jwtSecret = cacheFactory.getCachedReference("oauth2.provider.jwt.secret", providerSettingsDao::getJwtSecret, new CacheSettingsBuilder().remote().replicateAsynchronously().replicateViaInvalidation().build());
    }

    @Override
    public String getJwtSecret() {
        return (String)this.jwtSecret.get();
    }

    @Override
    public void reset() {
        this.providerSettingsDao.resetJwtSecret();
        this.jwtSecret.reset();
        this.jwtSecret.get();
    }

    @Override
    public void resetCachedValue() {
        this.jwtSecret.reset();
    }
}

