/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.token;

import com.atlassian.oauth2.scopes.api.Scope;
import java.util.Set;

public class AuthenticationResult {
    private final Set<Scope> scopes;
    private final String clientId;
    private final boolean authenticated;
    private final String grantTypeUsed;

    public static AuthenticationResult authenticated(Set<Scope> scope, String clientId, String grantTypeUsed) {
        return new AuthenticationResult(scope, clientId, grantTypeUsed, true);
    }

    public static AuthenticationResult notAuthenticated() {
        return new AuthenticationResult(null, null, null, false);
    }

    private AuthenticationResult(Set<Scope> scope, String clientId, String grantTypeUsed, boolean authenticated) {
        this.scopes = scope;
        this.clientId = clientId;
        this.authenticated = authenticated;
        this.grantTypeUsed = grantTypeUsed;
    }

    public Set<Scope> getScopes() {
        return this.scopes;
    }

    public String getClientId() {
        return this.clientId;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public String getGrantTypeUsed() {
        return this.grantTypeUsed;
    }
}

