/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.token;

import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import com.atlassian.oauth2.provider.core.token.AccessTokenAuthenticationHandler;
import com.atlassian.oauth2.provider.core.token.AuthenticationResult;
import com.atlassian.oauth2.provider.core.token.JwtService;
import com.atlassian.oauth2.provider.core.token.TokenService;
import com.atlassian.oauth2.provider.core.token.access.exception.ExpiredTokenException;
import com.atlassian.oauth2.provider.core.token.access.exception.UnrecognisedTokenException;
import com.atlassian.oauth2.provider.core.token.access.exception.UnrecognisedUserKeyException;
import com.atlassian.oauth2.provider.core.user.ProductUserProvider;
import com.atlassian.sal.api.auth.AuthenticationListener;
import com.atlassian.sal.api.auth.Authenticator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.user.UserKey;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.security.Principal;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultAccessTokenAuthenticationHandler
implements AccessTokenAuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(DefaultAccessTokenAuthenticationHandler.class);
    private final TokenService tokenService;
    private final AuthenticationListener authenticationListener;
    private final I18nResolver i18nResolver;
    private final ProductUserProvider productUserProvider;
    private final Clock clock;
    private final JwtService jwtService;
    private static final Duration ONE_HOUR = Duration.ofHours(1L);

    public DefaultAccessTokenAuthenticationHandler(TokenService tokenService, Clock clock, AuthenticationListener authenticationListener, I18nResolver i18nResolver, ProductUserProvider productUserProvider, JwtService jwtService) {
        this.tokenService = tokenService;
        this.authenticationListener = authenticationListener;
        this.i18nResolver = i18nResolver;
        this.productUserProvider = productUserProvider;
        this.clock = clock;
        this.jwtService = jwtService;
    }

    @Override
    public AuthenticationResult authenticate(HttpServletRequest request, HttpServletResponse response, String bearerToken) {
        String tokenIdClaim = this.jwtService.extractTokenId(bearerToken);
        AccessToken accessToken = this.lookupAccessToken(tokenIdClaim);
        this.validateAccessToken(accessToken);
        this.attemptAuthentication(request, response, tokenIdClaim, accessToken);
        return AuthenticationResult.authenticated(accessToken.getScopes(), accessToken.getClientId(), accessToken.getGrantTypeUsedToCreate());
    }

    private AccessToken lookupAccessToken(String tokenId) {
        return this.tokenService.findByAccessTokenId(tokenId).orElseThrow(() -> new UnrecognisedTokenException(this.i18nResolver.getText("oauth2.authentication.token.not.recognized")));
    }

    private void validateAccessToken(AccessToken accessToken) {
        if (this.hasExpired(accessToken)) {
            throw new ExpiredTokenException(this.i18nResolver.getText("oauth2.authentication.token.has.expired"));
        }
    }

    private boolean hasExpired(AccessToken token) {
        Instant tokenCreatedAt = Instant.ofEpochMilli(token.getCreatedAt());
        Duration systemMaxDuration = SystemProperty.MAX_ACCESS_TOKEN_LIFETIME.getValue();
        Duration actualMaxDuration = systemMaxDuration.toHours() > 1L ? ONE_HOUR : systemMaxDuration;
        Instant tokenExpiryTime = tokenCreatedAt.plus(actualMaxDuration);
        Instant now = Instant.ofEpochMilli(this.clock.millis());
        return now.isAfter(tokenExpiryTime);
    }

    private void attemptAuthentication(HttpServletRequest request, HttpServletResponse response, String tokenId, AccessToken accessToken) {
        String userKey = accessToken.getUserKey();
        if (StringUtils.isBlank((CharSequence)userKey)) {
            if (logger.isDebugEnabled()) {
                logger.debug("No user key found for access token [{}]. Authentication not required.", (Object)accessToken.getId());
            }
            this.tokenService.updateAccessTokenLastAccessed(tokenId);
            return;
        }
        Principal principal = this.productUserProvider.getActiveUserByKey(new UserKey(userKey)).orElseThrow(() -> new UnrecognisedUserKeyException(this.i18nResolver.getText("oauth2.authentication.token.user.not.recognized")));
        Message successMessage = this.i18nResolver.createMessage("oauth2.authentication.success", new Serializable[0]);
        this.authenticationListener.authenticationSuccess((Authenticator.Result)new Authenticator.Result.Success(successMessage, principal), request, response);
        this.tokenService.updateAccessTokenLastAccessed(tokenId);
    }
}

