/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.token.access.dao;

import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.scopes.api.Scope;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import jakarta.annotation.Nonnull;
import java.util.Set;

public record AccessTokenEntity(@Nonnull String id, @Nonnull String clientId, String userKey, String authorizationCode, @Nonnull Set<Scope> scopes, @Nonnull Long authorizationDate, @Nonnull Long createdAt, Long lastAccessed, @Nonnull String grantTypeUsedToCreate) implements AccessToken
{
    public static AccessTokenEntityBuilder builder() {
        return new AccessTokenEntityBuilder();
    }

    @Nonnull
    public String getId() {
        return this.id;
    }

    @Nonnull
    public String getClientId() {
        return this.clientId;
    }

    @Nonnull
    public String getUserKey() {
        return Strings.nullToEmpty((String)this.userKey);
    }

    @Nonnull
    public String getAuthorizationCode() {
        return Strings.nullToEmpty((String)this.authorizationCode);
    }

    @Nonnull
    public Set<Scope> getScopes() {
        return this.scopes;
    }

    @Nonnull
    public String getGrantTypeUsedToCreate() {
        return this.grantTypeUsedToCreate;
    }

    @Nonnull
    public Long getAuthorizationDate() {
        return this.authorizationDate;
    }

    @Nonnull
    public Long getCreatedAt() {
        return this.createdAt;
    }

    public Long getLastAccessed() {
        return this.lastAccessed;
    }

    @Nonnull
    public Scope getScope() {
        return (Scope)this.scopes.stream().findFirst().orElseThrow();
    }

    public AccessTokenEntityBuilder toBuilder() {
        return new AccessTokenEntityBuilder().id(this.id).clientId(this.clientId).userKey(this.userKey).authorizationCode(this.authorizationCode).scopes(this.scopes).authorizationDate(this.authorizationDate).createdAt(this.createdAt).lastAccessed(this.lastAccessed).grantTypeUsedToCreate(this.grantTypeUsedToCreate);
    }

    public static class AccessTokenEntityBuilder {
        private String id;
        private String clientId;
        private String userKey;
        private String authorizationCode;
        private Set<Scope> scopes;
        private Long authorizationDate;
        private Long createdAt;
        private Long lastAccessed;
        private String grantTypeUsedToCreate;

        AccessTokenEntityBuilder() {
        }

        public AccessTokenEntityBuilder id(String id) {
            this.id = id;
            return this;
        }

        public AccessTokenEntityBuilder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public AccessTokenEntityBuilder userKey(String userKey) {
            this.userKey = userKey;
            return this;
        }

        public AccessTokenEntityBuilder authorizationCode(String authorizationCode) {
            this.authorizationCode = authorizationCode;
            return this;
        }

        public AccessTokenEntityBuilder scopes(Set<Scope> scopes) {
            this.scopes = scopes;
            return this;
        }

        public AccessTokenEntityBuilder authorizationDate(Long authorizationDate) {
            this.authorizationDate = authorizationDate;
            return this;
        }

        public AccessTokenEntityBuilder createdAt(Long createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public AccessTokenEntityBuilder lastAccessed(Long lastAccessed) {
            this.lastAccessed = lastAccessed;
            return this;
        }

        public AccessTokenEntityBuilder grantTypeUsedToCreate(String grantTypeUsedToCreate) {
            this.grantTypeUsedToCreate = grantTypeUsedToCreate;
            return this;
        }

        public AccessTokenEntity build() {
            return new AccessTokenEntity((String)Preconditions.checkNotNull((Object)this.id), (String)Preconditions.checkNotNull((Object)this.clientId), this.userKey, this.authorizationCode, (Set)Preconditions.checkNotNull(this.scopes), (Long)Preconditions.checkNotNull((Object)this.authorizationDate), (Long)Preconditions.checkNotNull((Object)this.createdAt), this.lastAccessed, this.grantTypeUsedToCreate);
        }

        public String toString() {
            return "AccessTokenEntityBuilder{id='" + this.id + "', clientId='" + this.clientId + "', userKey='" + this.userKey + "', authorizationCode='" + this.authorizationCode + "', scopes=" + String.valueOf(this.scopes) + ", authorizationDate=" + this.authorizationDate + ", createdAt=" + this.createdAt + ", lastAccessed=" + this.lastAccessed + ", grantTypeUsedToCreate='" + this.grantTypeUsedToCreate + "'}";
        }
    }
}

