/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.token.refresh.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.provider.core.dao.OAuth2ProviderDao;
import com.atlassian.oauth2.provider.core.token.refresh.dao.RefreshTokenDao;
import com.atlassian.oauth2.provider.core.token.refresh.dao.RefreshTokenEntity;
import com.atlassian.oauth2.provider.core.token.refresh.dao.entity.AORefreshToken;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.google.common.collect.ImmutableMap;
import jakarta.annotation.Nonnull;
import java.time.Clock;
import java.time.Duration;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultRefreshTokenDao
extends OAuth2ProviderDao
implements RefreshTokenDao {
    private static final Logger logger = LoggerFactory.getLogger(DefaultRefreshTokenDao.class);
    private static final String WHERE_TOKEN_ID_EQUAL_TO = "ID = ?";
    private static final String WHERE_CLIENT_ID_EQUAL_TO = "CLIENT_ID = ?";
    private static final String WHERE_ACCESS_TOKEN_ID_EQUAL_TO = "ACCESS_TOKEN_ID = ?";
    private static final String WHERE_USER_KEY_EQUAL_TO = "USER_KEY = ?";
    private static final String WHERE_CLIENT_ID_EQUAL_TO_AND_USER_KEY_EQUAL_TO = "CLIENT_ID = ? AND USER_KEY = ?";
    private static final String WHERE_CODE_EQUAL_TO = "AUTHORIZATION_CODE = ?";
    private final Clock clock;
    private final ScopeResolver scopeResolver;

    public DefaultRefreshTokenDao(ActiveObjects activeObjects, Clock clock, ScopeResolver scopeResolver) {
        super(activeObjects);
        this.clock = clock;
        this.scopeResolver = scopeResolver;
    }

    @Override
    @Nonnull
    public RefreshToken create(RefreshToken refreshTokenEntity) {
        logger.debug("Creating an refresh token with id [{}].", (Object)refreshTokenEntity.getId());
        return (RefreshToken)this.activeObjects.executeInTransaction(() -> {
            ((AORefreshToken)this.activeObjects.create(AORefreshToken.class, this.toEntityAttributes(refreshTokenEntity))).save();
            return refreshTokenEntity;
        });
    }

    private Map<String, Object> toEntityAttributes(RefreshToken refreshTokenEntity) {
        ImmutableMap.Builder attributes = ImmutableMap.builder().put((Object)"ID", (Object)refreshTokenEntity.getId()).put((Object)"CLIENT_ID", (Object)refreshTokenEntity.getClientId()).put((Object)"USER_KEY", (Object)refreshTokenEntity.getUserKey()).put((Object)"ACCESS_TOKEN_ID", (Object)refreshTokenEntity.getAccessTokenId()).put((Object)"SCOPE", (Object)ScopeResolver.serializeScopesToStr((Set)refreshTokenEntity.getScopes())).put((Object)"AUTHORIZATION_CODE", (Object)refreshTokenEntity.getAuthorizationCode()).put((Object)"AUTHORIZATION_DATE", (Object)refreshTokenEntity.getAuthorizationDate()).put((Object)"CREATED_AT", (Object)refreshTokenEntity.getCreatedAt());
        if (refreshTokenEntity.getRefreshCount() != null) {
            attributes.put((Object)"REFRESH_COUNT", (Object)refreshTokenEntity.getRefreshCount());
        }
        return attributes.build();
    }

    @Override
    @Nonnull
    public Optional<RefreshToken> findByTokenId(String tokenId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> this.findEntity(tokenId).map(this::toEntity));
    }

    private Optional<AORefreshToken> findEntity(String tokenId) {
        AORefreshToken[] entities = (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_TOKEN_ID_EQUAL_TO, new Object[]{tokenId});
        if (entities.length > 0) {
            logger.debug("Found refresh token associated with token id [{}].", (Object)tokenId);
            return Optional.of(entities[0]);
        }
        logger.debug("Failed to find a refresh token associated with token id [{}].", (Object)tokenId);
        return Optional.empty();
    }

    @Override
    @Nonnull
    public List<RefreshToken> findByClientId(String clientId) {
        return (List)this.activeObjects.executeInTransaction(() -> this.toEntities(this.findEntityByClientId(clientId)));
    }

    @Override
    @Nonnull
    public List<RefreshToken> findByUserKey(String userKey) {
        return (List)this.activeObjects.executeInTransaction(() -> this.toEntities((AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_USER_KEY_EQUAL_TO, new Object[]{userKey})));
    }

    @Override
    @Nonnull
    public List<RefreshToken> findByAuthorizationCode(String authorizationCode) {
        return (List)this.activeObjects.executeInTransaction(() -> this.toEntities(this.findEntitiesByAuthorizationCode(authorizationCode)));
    }

    @Override
    public void removeExpiredTokensAfter(Duration expiration) {
        logger.debug("Removing expired refresh tokens after [{}].", (Object)expiration);
        this.activeObjects.executeInTransaction(() -> this.activeObjects.deleteWithSQL(AORefreshToken.class, this.whereColumnIsGreaterThanValue("CREATED_AT"), new Object[]{this.clock.millis(), expiration.toMillis()}));
    }

    @Override
    @Nonnull
    public Optional<RefreshToken> removeByRefreshTokenId(String refreshTokenId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> {
            logger.debug("Removing refresh token with id [{}].", (Object)refreshTokenId);
            AORefreshToken[] tokenToRemove = (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_TOKEN_ID_EQUAL_TO, new Object[]{refreshTokenId});
            if (tokenToRemove.length == 1) {
                this.activeObjects.deleteWithSQL(AORefreshToken.class, WHERE_TOKEN_ID_EQUAL_TO, new Object[]{refreshTokenId});
                logger.debug("Successfully removed refresh token with id [{}].", (Object)refreshTokenId);
                return Optional.of(this.toEntity(tokenToRemove[0]));
            }
            logger.debug("Unable to find a refresh token with id [{}]. No tokens have been removed.", (Object)refreshTokenId);
            return Optional.empty();
        });
    }

    @Override
    public Optional<RefreshToken> removeByAccessTokenId(String accessTokenId) {
        return (Optional)this.activeObjects.executeInTransaction(() -> {
            logger.debug("Removing refresh token associated with access token id [{}].", (Object)accessTokenId);
            AORefreshToken[] aoRefreshTokens = (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_ACCESS_TOKEN_ID_EQUAL_TO, new Object[]{accessTokenId});
            if (aoRefreshTokens.length == 1) {
                this.activeObjects.deleteWithSQL(AORefreshToken.class, WHERE_ACCESS_TOKEN_ID_EQUAL_TO, new Object[]{accessTokenId});
                logger.debug("Successfully removed refresh token associated with access token id [{}].", (Object)accessTokenId);
                return Optional.of(this.toEntity(aoRefreshTokens[0]));
            }
            logger.debug("Unable to find a refresh token associated with access token id [{}]. No tokens have been removed.", (Object)accessTokenId);
            return Optional.empty();
        });
    }

    @Override
    @Nonnull
    public List<RefreshToken> removeByClientId(String clientId) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            logger.debug("Removing refresh tokens associated with client id [{}].", (Object)clientId);
            AORefreshToken[] removedTokens = this.findEntityByClientId(clientId);
            if (removedTokens.length > 0) {
                this.activeObjects.deleteWithSQL(AORefreshToken.class, WHERE_CLIENT_ID_EQUAL_TO, new Object[]{clientId});
                logger.debug("Successfully removed refresh tokens associated with client id [{}].", (Object)clientId);
            }
            return this.toEntities(removedTokens);
        });
    }

    @Override
    public List<RefreshToken> removeAllByAuthorizationCode(String authorizationCode) {
        return (List)this.activeObjects.executeInTransaction(() -> {
            logger.debug("Removing refresh tokens associated with authorization code [{}].", (Object)authorizationCode);
            AORefreshToken[] tokensToRemove = this.findEntitiesByAuthorizationCode(authorizationCode);
            if (tokensToRemove.length > 0) {
                this.activeObjects.deleteWithSQL(AORefreshToken.class, WHERE_CODE_EQUAL_TO, new Object[]{authorizationCode});
                logger.debug("Successfully removed refresh tokens associated with authorization code [{}].", (Object)authorizationCode);
            }
            return this.toEntities(tokensToRemove);
        });
    }

    @Override
    public void removeOldestIfLimitExceeded(String clientId, String userKey, int maxAllowedTokens) {
        this.activeObjects.executeInTransaction(() -> {
            int currentTokensCount = this.countByClientIdAndUserKey(clientId, userKey);
            logger.debug("Checking if the number of refresh tokens for client id [{}] and user key [{}] exceeds the limit of [{}]. Current count is [{}].", new Object[]{clientId, userKey, maxAllowedTokens, currentTokensCount});
            if (currentTokensCount > maxAllowedTokens) {
                Query query = Query.select().where(WHERE_CLIENT_ID_EQUAL_TO_AND_USER_KEY_EQUAL_TO, new Object[]{clientId, userKey}).order("CREATED_AT ASC").limit(currentTokensCount - maxAllowedTokens);
                RawEntity[] refreshTokens = (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, query);
                this.activeObjects.delete(refreshTokens);
                logger.debug("Successfully removed [{}] refresh tokens for client id [{}] and user key [{}].", new Object[]{refreshTokens.length, clientId, userKey});
                for (RawEntity token : refreshTokens) {
                    logger.debug("Removed refresh token id: [{}], creation time: [{}], refresh count: [{}].", new Object[]{token.getId(), token.getCreatedAt(), token.getRefreshCount()});
                }
            }
            return Optional.empty();
        });
    }

    public int countByClientIdAndUserKey(String clientId, String userKey) {
        return this.activeObjects.count(AORefreshToken.class, WHERE_CLIENT_ID_EQUAL_TO_AND_USER_KEY_EQUAL_TO, new Object[]{clientId, userKey});
    }

    public List<RefreshToken> findByClientIdAndUserKey(String clientId, String userKey) {
        return this.toEntities((AORefreshToken[])this.activeObjects.find(AORefreshToken.class, Query.select().where(WHERE_CLIENT_ID_EQUAL_TO_AND_USER_KEY_EQUAL_TO, new Object[]{clientId, userKey}).order("CREATED_AT ASC")));
    }

    public int countAll() {
        return this.activeObjects.count(AORefreshToken.class);
    }

    @Override
    public void removeAll() {
        this.activeObjects.executeInTransaction(() -> {
            logger.debug("Removing all refresh tokens.");
            int deleted = this.activeObjects.deleteWithSQL(AORefreshToken.class, "ID IS NOT NULL", new Object[0]);
            logger.debug("Successfully removed all {} refresh tokens.", (Object)deleted);
            return deleted;
        });
    }

    private AORefreshToken[] findEntityByClientId(String clientId) {
        return (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_CLIENT_ID_EQUAL_TO, new Object[]{clientId});
    }

    private List<RefreshToken> toEntities(AORefreshToken[] refreshTokens) {
        return Arrays.stream(refreshTokens).map(this::toEntity).collect(Collectors.toList());
    }

    private AORefreshToken[] findEntitiesByAuthorizationCode(String authorizationCode) {
        return (AORefreshToken[])this.activeObjects.find(AORefreshToken.class, WHERE_CODE_EQUAL_TO, new Object[]{authorizationCode});
    }

    private RefreshToken toEntity(AORefreshToken aoRefreshToken) {
        return RefreshTokenEntity.builder().id(aoRefreshToken.getId()).clientId(aoRefreshToken.getClientId()).userKey(aoRefreshToken.getUserKey()).accessTokenId(aoRefreshToken.getAccessTokenId()).scopes(this.scopeResolver.resolveAllGrantedScopesFromString(aoRefreshToken.getScope())).authorizationCode(aoRefreshToken.getAuthorizationCode()).authorizationDate(aoRefreshToken.getAuthorizationDate()).createdAt(aoRefreshToken.getCreatedAt()).refreshCount(aoRefreshToken.getRefreshCount()).build();
    }
}

