/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.core.web;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.oauth2.provider.api.client.ClientService;
import com.atlassian.oauth2.provider.core.event.OAuth2ProviderEventPublisher;
import com.atlassian.oauth2.provider.core.plugin.PluginChecker;
import com.atlassian.oauth2.provider.core.properties.SystemProperty;
import com.atlassian.oauth2.provider.core.token.AccessTokenAuthenticationHandler;
import com.atlassian.oauth2.provider.core.token.AuthenticationResult;
import com.atlassian.oauth2.provider.core.web.ApplicationNameSupplier;
import com.atlassian.oauth2.scopes.api.Closeable;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@UnrestrictedAccess
public class AccessTokenFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(AccessTokenFilter.class);
    private static final String CLIENT_CONFIGURATION_ID_ATTRIBUTE = "oauth2.token.client_configuration_id";
    private static final String CLIENT_ID_ATTRIBUTE = "oauth2.token.client_id";
    private static final String GRANT_TYPE_ATTRIBUTE = "oauth2.token.grant_type";
    private final AccessTokenAuthenticationHandler accessTokenAuthenticationHandler;
    private final PluginChecker pluginChecker;
    private final ScopesRequestCache scopesRequestCache;
    private final ClientService clientService;
    private final OAuth2ProviderEventPublisher oauth2ProviderEventPublisher;

    public AccessTokenFilter(AccessTokenAuthenticationHandler accessTokenAuthenticationHandler, PluginChecker pluginChecker, ScopesRequestCache scopesRequestCache, ClientService clientService, OAuth2ProviderEventPublisher oauth2ProviderEventPublisher) {
        this.accessTokenAuthenticationHandler = accessTokenAuthenticationHandler;
        this.pluginChecker = pluginChecker;
        this.scopesRequestCache = scopesRequestCache;
        this.clientService = clientService;
        this.oauth2ProviderEventPublisher = oauth2ProviderEventPublisher;
    }

    public void init(FilterConfig filterConfig) {
        logger.info("Initializing: [{}]", (Object)AccessTokenFilter.class.getSimpleName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!this.pluginChecker.isOAuth2ScopesPluginEnabled()) {
            logger.debug("OAuth 2 is not enabled as OAuth 2 Scopes plugin is disabled.");
            chain.doFilter(request, response);
            return;
        }
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        AuthenticationResult authenticationResult = AuthenticationResult.notAuthenticated();
        AtomicBoolean chainDoFilterCalled = new AtomicBoolean(false);
        try {
            if (SystemProperty.ENABLE_ACCESS_TOKENS.getValue().booleanValue()) {
                authenticationResult = this.attemptAuthenticationWithAccessToken(httpRequest, httpResponse);
            }
            if (authenticationResult.isAuthenticated()) {
                this.setAttributeForWebSudo(httpRequest);
                this.setAttributeForLoginFilters(httpRequest);
                this.setGrantTypeAttribute(httpRequest, authenticationResult);
                this.setClientIdAttribute(httpRequest, authenticationResult);
            }
            try (Closeable scopes = this.scopesRequestCache.withScopes(authenticationResult.getScopes(), (Supplier)new ApplicationNameSupplier(authenticationResult.getClientId(), this.clientService));){
                chainDoFilterCalled.set(true);
                chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
            }
        }
        catch (Exception e) {
            logger.debug("Failure in OAuth 2 filter", (Throwable)e);
            if (e instanceof ServletException) {
                throw (ServletException)e;
            }
            if (e instanceof IOException) {
                throw (IOException)e;
            }
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new ServletException((Throwable)e);
        }
        finally {
            try {
                if (!chainDoFilterCalled.get()) {
                    logger.debug("chain.doFilter was not called. So calling it now");
                    chain.doFilter((ServletRequest)httpRequest, (ServletResponse)httpResponse);
                }
            }
            finally {
                if (authenticationResult.isAuthenticated()) {
                    this.invalidateAnyExistingSession(httpRequest);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AuthenticationResult attemptAuthenticationWithAccessToken(HttpServletRequest request, HttpServletResponse response) {
        block5: {
            Optional<String> bearerToken = this.extractToken(request);
            if (!bearerToken.isPresent()) break block5;
            try {
                AuthenticationResult authenticationResult = this.accessTokenAuthenticationHandler.authenticate(request, response, bearerToken.get());
                response.setHeader("Cache-Control", "private");
                AuthenticationResult authenticationResult2 = authenticationResult;
                this.oauth2ProviderEventPublisher.publishClientIncomingConnectionEvent();
                return authenticationResult2;
            }
            catch (Throwable throwable) {
                try {
                    this.oauth2ProviderEventPublisher.publishClientIncomingConnectionEvent();
                    throw throwable;
                }
                catch (Exception e) {
                    logger.debug("Failed to authenticate request via OAuth2 access token [{}] - [{}]", (Object)request.hashCode(), (Object)e);
                }
            }
        }
        return AuthenticationResult.notAuthenticated();
    }

    private Optional<String> extractToken(HttpServletRequest request) {
        if (request.getHeader("Authorization") != null) {
            return this.parseToken(request.getHeader("Authorization"));
        }
        return this.extractTokenFromCookies(request.getCookies()).flatMap(this::parseToken);
    }

    private Optional<String> extractTokenFromCookies(Cookie[] cookies) {
        return Optional.ofNullable(cookies).stream().flatMap(Arrays::stream).filter(cookie -> SystemProperty.TOKEN_COOKIE_NAME.getValue().equals(cookie.getName())).map(Cookie::getValue).findFirst().map(token -> URLDecoder.decode(token, StandardCharsets.UTF_8));
    }

    private Optional<String> parseToken(String accessToken) {
        return Optional.ofNullable(accessToken).map(header -> header.split(" ", 2)).filter(authorizationSegments -> ((String[])authorizationSegments).length == 2).flatMap(authorizationHeaderValue -> {
            Optional<String> token = this.extractBearerToken((String[])authorizationHeaderValue);
            if (token.isEmpty()) {
                token = this.extractTokenFromBasicAuthentication((String[])authorizationHeaderValue);
            }
            return token;
        });
    }

    private Optional<String> extractBearerToken(String[] authorizationParameters) {
        if ("Bearer".equals(authorizationParameters[0])) {
            return Optional.of(authorizationParameters[1]);
        }
        return Optional.empty();
    }

    private Optional<String> extractTokenFromBasicAuthentication(String[] authorizationParameters) {
        if (SystemProperty.TOKEN_VIA_BASIC_AUTHENTICATION.getValue().booleanValue() && "Basic".equalsIgnoreCase(authorizationParameters[0])) {
            try {
                String[] basicAuthorizationUserAndPasswordPair = new String(Base64.getDecoder().decode(authorizationParameters[1]), StandardCharsets.ISO_8859_1).split(":");
                if (basicAuthorizationUserAndPasswordPair.length == 2) {
                    return Optional.ofNullable(basicAuthorizationUserAndPasswordPair[1]);
                }
            }
            catch (Exception e) {
                logger.debug("Failed to decode basic authentication value", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    private void setAttributeForWebSudo(HttpServletRequest req) {
        req.setAttribute("access.token.request", (Object)Boolean.TRUE);
    }

    private void setGrantTypeAttribute(HttpServletRequest req, AuthenticationResult authenticationResult) {
        req.setAttribute(GRANT_TYPE_ATTRIBUTE, (Object)authenticationResult.getGrantTypeUsed());
    }

    private void setAttributeForLoginFilters(HttpServletRequest req) {
        req.setAttribute("loginfilter.already.filtered", (Object)Boolean.TRUE);
    }

    private void setClientIdAttribute(HttpServletRequest httpRequest, AuthenticationResult authenticationResult) {
        this.clientService.getByClientId(authenticationResult.getClientId()).or(() -> this.clientService.getByRotatedClientId(authenticationResult.getClientId())).ifPresent(client -> {
            httpRequest.setAttribute(CLIENT_CONFIGURATION_ID_ATTRIBUTE, (Object)client.getId());
            httpRequest.setAttribute(CLIENT_ID_ATTRIBUTE, (Object)client.getClientId());
        });
    }

    private void invalidateAnyExistingSession(HttpServletRequest httpRequest) {
        if (SystemProperty.INVALIDATE_SESSION_ENABLED.getValue().booleanValue()) {
            HttpSession session = httpRequest.getSession(false);
            try {
                if (session != null) {
                    logger.debug("Invalidating session authenticated using OAuth 2 token with an ID [{}]", (Object)session.getId());
                    session.invalidate();
                }
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
    }

    public void destroy() {
        logger.info("Destroying: [{}]", (Object)AccessTokenFilter.class.getSimpleName());
    }
}

