/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.oauth2.provider.rest.model.RestAuthorizationRequest;
import com.atlassian.oauth2.provider.rest.service.AuthorizationRestService;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="authorize")
@Singleton
public class AuthorizationResource {
    private static final Logger logger = LoggerFactory.getLogger(AuthorizationResource.class);
    private final AuthorizationRestService authorizationRestService;

    @Inject
    public AuthorizationResource(AuthorizationRestService authorizationRestService) {
        this.authorizationRestService = authorizationRestService;
    }

    @GET
    @UnrestrictedAccess
    @PublicApi
    public Response authorize(@Context HttpServletRequest httpServletRequest, @QueryParam(value="client_id") String clientId, @QueryParam(value="redirect_uri") String redirectUri, @QueryParam(value="state") String state, @QueryParam(value="response_type") String responseType, @QueryParam(value="scope") String scope, @QueryParam(value="code_challenge_method") String codeChallengeMethod, @QueryParam(value="code_challenge") String codeChallenge) {
        logger.debug("Authorizing request for client ID [{}]", (Object)clientId);
        RestAuthorizationRequest request = RestAuthorizationRequest.builder().clientId(clientId).redirectUri(redirectUri).state(state).responseType(responseType).scope(StringUtils.defaultString((String)scope)).codeChallengeMethod(codeChallengeMethod).codeChallenge(codeChallenge).build();
        return Response.seeOther((URI)this.authorizationRestService.getRedirectUri(httpServletRequest, request)).header("Cache-Control", (Object)"no-store").header("Pragma", (Object)"no-cache").build();
    }
}

