/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.resource;

import com.atlassian.annotations.PublicApi;
import com.atlassian.oauth2.common.rest.validator.ErrorCollection;
import com.atlassian.oauth2.provider.core.credentials.ClientCredentialsGenerator;
import com.atlassian.oauth2.provider.rest.exception.ClientNotFoundException;
import com.atlassian.oauth2.provider.rest.exception.ValidationException;
import com.atlassian.oauth2.provider.rest.service.RotateClientService;
import com.atlassian.plugins.rest.api.security.annotation.SystemAdminOnly;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="rotate")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Singleton
@SystemAdminOnly
public class RotateResource {
    private static final Logger logger = LoggerFactory.getLogger(RotateResource.class);
    private final RotateClientService rotateClientService;

    @Inject
    public RotateResource(RotateClientService rotateClientService) {
        this.rotateClientService = rotateClientService;
    }

    @POST
    @Path(value="/{clientId}")
    @PublicApi
    public Response rotate(@PathParam(value="clientId") String clientId) throws ValidationException, ClientNotFoundException {
        if (!ClientCredentialsGenerator.isValidGeneratedKey(clientId, ClientCredentialsGenerator.Length.THIRTY_TWO)) {
            throw new ValidationException(ErrorCollection.forMessage("clientId must be a valid hex-encoded string of length 64"));
        }
        logger.debug("Rotating client id and secret for clientId {}", (Object)clientId);
        return Response.ok((Object)this.rotateClientService.rotate(clientId)).build();
    }
}

