/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service;

import com.atlassian.sal.api.features.DarkFeatureManager;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ApplinksOAuth2ScopesAlowlist {
    public static final String BAMBOO = "bamboo";
    public static final String BITBUCKET = "bitbucket";
    public static final String CONFLUENCE = "confluence";
    public static final String CROWD = "crowd";
    public static final String JIRA = "jira";
    private static final String JSM_KB_SCOPE_FEATURE_KEY = "scope.jsm.kb";
    private static final String JSM_KB = "JSM_KB";
    private static final Set<String> JIRA_ALLOWLISTED_SCOPES = Set.of("READ", "WRITE", "JSM_KB");
    private static final Set<String> CONFLUENCE_ALLOWLISTED_SCOPES = Set.of("READ", "WRITE", "JSM_KB");
    private static final Set<String> BITBUCKET_ALLOWLISTED_SCOPES = Set.of("PUBLIC_REPOS", "ACCOUNT_WRITE", "REPO_READ", "REPO_WRITE", "REPO_ADMIN", "PROJECT_ADMIN");
    private static final Set<String> BAMBOO_ALLOWLISTED_SCOPES = Set.of("READ", "TRIGGER", "USER");
    private static final Set<String> CROWD_ALLOWLISTED_SCOPES = Set.of("USER");
    private final DarkFeatureManager darkFeatureManager;
    private final String applicationType;

    public ApplinksOAuth2ScopesAlowlist(DarkFeatureManager darkFeatureManager, String applicationType) {
        Objects.requireNonNull(darkFeatureManager, "DarkFeatureManager cannot be null");
        Objects.requireNonNull(applicationType, "Application type cannot be null");
        this.darkFeatureManager = darkFeatureManager;
        this.applicationType = applicationType;
    }

    public Set<String> filterAvailableScopes(Set<String> availableScopes) {
        return switch (this.applicationType) {
            case BAMBOO -> this.filterAvailableScopes(availableScopes, BAMBOO_ALLOWLISTED_SCOPES::contains);
            case BITBUCKET -> this.filterAvailableScopes(availableScopes, BITBUCKET_ALLOWLISTED_SCOPES::contains);
            case CONFLUENCE -> this.filterAvailableScopes(availableScopes, CONFLUENCE_ALLOWLISTED_SCOPES::contains);
            case CROWD -> this.filterAvailableScopes(availableScopes, CROWD_ALLOWLISTED_SCOPES::contains);
            case JIRA -> this.filterJiraAvailableScopes(availableScopes);
            default -> throw new IllegalArgumentException("Unknown application type: " + this.applicationType);
        };
    }

    private Set<String> filterJiraAvailableScopes(Set<String> availableScopes) {
        HashSet<String> scopes = new HashSet<String>(this.filterAvailableScopes(availableScopes, JIRA_ALLOWLISTED_SCOPES::contains));
        if (!this.isDarkFeatureEnabledForAllUsers(JSM_KB_SCOPE_FEATURE_KEY)) {
            scopes.remove(JSM_KB);
        }
        return scopes;
    }

    private Set<String> filterAvailableScopes(Set<String> availableScopes, Predicate<String> filter) {
        return availableScopes.stream().filter(filter).collect(Collectors.toSet());
    }

    private boolean isDarkFeatureEnabledForAllUsers(String darkFeatureKey) {
        Objects.requireNonNull(darkFeatureKey, "Dark feature key cannot be null");
        return this.darkFeatureManager.isEnabledForAllUsers(darkFeatureKey).orElse(Boolean.FALSE);
    }
}

