/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service;

import com.atlassian.audit.api.AuditService;
import com.atlassian.audit.entity.AuditAttribute;
import com.atlassian.audit.entity.AuditEvent;
import com.atlassian.audit.entity.CoverageArea;
import com.atlassian.audit.entity.CoverageLevel;
import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.provider.core.token.JwtService;
import com.atlassian.oauth2.provider.core.token.TokenService;
import com.atlassian.oauth2.provider.rest.exception.InvalidClientException;
import com.atlassian.oauth2.provider.rest.exception.InvalidRequestException;
import com.atlassian.oauth2.provider.rest.exception.UnsupportedTokenTypeException;
import com.atlassian.oauth2.provider.rest.model.RevokeRequestFormParams;
import com.atlassian.oauth2.provider.rest.validation.RevokeTokenValidator;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RevokeTokenService {
    private static final Logger logger = LoggerFactory.getLogger(RevokeTokenService.class);
    private final TokenService tokenService;
    private final RevokeTokenValidator revokeTokenValidator;
    private final JwtService jwtService;
    private final UserManager userManager;
    private final AuditService auditService;
    private final I18nResolver i18nResolver;

    public RevokeTokenService(TokenService tokenService, RevokeTokenValidator revokeTokenValidator, JwtService jwtService, UserManager userManager, AuditService auditService, I18nResolver i18nResolver) {
        this.tokenService = tokenService;
        this.revokeTokenValidator = revokeTokenValidator;
        this.jwtService = jwtService;
        this.userManager = userManager;
        this.auditService = auditService;
        this.i18nResolver = i18nResolver;
    }

    public void revokeToken(RevokeRequestFormParams formParams) throws InvalidClientException, InvalidRequestException, UnsupportedTokenTypeException {
        if (this.revokeTokenValidator.isRevokeRequestValid(formParams)) {
            logger.debug("Revoke request valid, proceeding to revoke token");
            String tokenId = this.jwtService.extractTokenId(formParams.getToken());
            if ("access_token".equals(formParams.getTokenTypeHint())) {
                logger.debug("Token type hint provided (access_token). Revoking token using access token id");
                this.revokeUsingAccessToken(tokenId);
            } else if ("refresh_token".equals(formParams.getTokenTypeHint())) {
                logger.debug("Token type hint provided (refresh_token). Revoking token using access token id");
                this.revokeUsingRefreshToken(tokenId);
            } else if (StringUtils.isBlank((CharSequence)formParams.getTokenTypeHint())) {
                logger.debug("No token type hint provided");
                this.revokeUsingAccessToken(tokenId);
                this.revokeUsingRefreshToken(tokenId);
            } else {
                throw new UnsupportedTokenTypeException("oauth2.rest.error.unsupported.token.type");
            }
        }
    }

    @Deprecated
    public void revokeToken(String tokenId) throws InvalidRequestException {
        if (!this.tokenService.removeTokensById(tokenId)) {
            throw new InvalidRequestException(this.i18nResolver.getText("oauth2.rest.error.revoke.token"));
        }
    }

    public void revokeJwt(String jwt) throws InvalidRequestException {
        String internalTokenId = this.jwtService.extractTokenId(jwt);
        if (!this.tokenService.removeCurrentUsersTokensById(internalTokenId)) {
            throw new InvalidRequestException(this.i18nResolver.getText("oauth2.rest.error.revoke.token"));
        }
    }

    private void revokeUsingAccessToken(String accessTokenId) {
        this.tokenService.removeAccessTokenById(accessTokenId).ifPresent(this::logAccessTokenRevokedAuditEvent);
        this.tokenService.removeRefreshTokenAssociatedWith(accessTokenId);
    }

    private void revokeUsingRefreshToken(String refreshTokenId) {
        this.tokenService.removeAccessTokenAssociatedWith(refreshTokenId);
        this.tokenService.removeRefreshToken(refreshTokenId).ifPresent(this::logRefreshTokenRevokedAuditEvent);
    }

    public void revokeAllRefreshTokensForCurrentUser() {
        this.tokenService.removeCurrentUserRefreshTokens();
        this.logAllTokensForUserRevokedAuditEvent(Objects.requireNonNull(this.userManager.getRemoteUserKey()));
    }

    public void revokeAllRefreshTokensForUser(UserKey userKey) {
        this.tokenService.removeUserRefreshTokens(userKey);
        this.logAllTokensForUserRevokedAuditEvent(userKey);
    }

    public void revokeAllRefreshTokens() {
        this.tokenService.removeAllRefreshTokens();
        this.logAllTokensRevokedAuditEvent();
    }

    private void logAccessTokenRevokedAuditEvent(AccessToken accessToken) {
        this.logTokenRevokedAuditEvent(RevokeTokenService.clientIdAuditAttribute(accessToken.getClientId()), RevokeTokenService.userKeyAuditAttribute(accessToken.getUserKey()), RevokeTokenService.accessTokenAuditAttribute(accessToken));
    }

    private void logRefreshTokenRevokedAuditEvent(RefreshToken refreshToken) {
        this.logTokenRevokedAuditEvent(RevokeTokenService.clientIdAuditAttribute(refreshToken.getClientId()), RevokeTokenService.userKeyAuditAttribute(refreshToken.getUserKey()), RevokeTokenService.refreshTokenAuditAttribute(refreshToken));
    }

    private void logAllTokensForUserRevokedAuditEvent(UserKey userKey) {
        this.logTokenRevokedAuditEvent(RevokeTokenService.userKeyAuditAttribute(userKey.getStringValue()), RevokeTokenService.allRefreshTokensAuditAttribute());
    }

    private void logAllTokensRevokedAuditEvent() {
        this.logTokenRevokedAuditEvent(RevokeTokenService.userKeyAuditAttribute("*"), RevokeTokenService.allRefreshTokensAuditAttribute());
    }

    private void logTokenRevokedAuditEvent(AuditAttribute ... attributes) {
        AuditEvent event = AuditEvent.fromI18nKeys((String)"audit.logging.category.security", (String)"audit.logging.summary.token.revoked", (CoverageLevel)CoverageLevel.BASE, (CoverageArea)CoverageArea.GLOBAL_CONFIG_AND_ADMINISTRATION).extraAttributes(Arrays.asList(attributes)).build();
        this.auditService.audit(event);
    }

    private static AuditAttribute clientIdAuditAttribute(String clientId) {
        return AuditAttribute.fromI18nKeys((String)"audit.logging.summary.client.id", (String)clientId).build();
    }

    private static AuditAttribute userKeyAuditAttribute(String userKey) {
        return AuditAttribute.fromI18nKeys((String)"audit.logging.summary.user.key", (String)userKey).build();
    }

    private static AuditAttribute accessTokenAuditAttribute(AccessToken accessToken) {
        return AuditAttribute.fromI18nKeys((String)"audit.logging.summary.access.token", (String)accessToken.getId()).build();
    }

    private static AuditAttribute refreshTokenAuditAttribute(RefreshToken refreshToken) {
        return AuditAttribute.fromI18nKeys((String)"audit.logging.summary.refresh.token", (String)refreshToken.getId()).build();
    }

    private static AuditAttribute allRefreshTokensAuditAttribute() {
        return AuditAttribute.fromI18nKeys((String)"audit.logging.summary.refresh.token", (String)"*").build();
    }
}

