/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service;

import com.atlassian.oauth2.provider.rest.model.PageDto;
import com.atlassian.oauth2.provider.rest.model.ScopeDto;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.message.I18nResolver;
import io.atlassian.util.concurrent.LazyReference;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScopeRestService {
    private static final Logger logger = LoggerFactory.getLogger(ScopeRestService.class);
    private final ScopeResolver scopeResolver;
    private final I18nResolver i18nResolver;
    private final ApplicationProperties applicationProperties;
    private final String i18nKeyPrefix;
    private final LazyReference<List<UntranslatedScope>> availableScopes = new LazyReference<List<UntranslatedScope>>(){

        protected List<UntranslatedScope> create() {
            return ScopeRestService.this.resolveAvailableScopes();
        }
    };
    private final Comparator<? super Scope> ScopeSorter = Comparator.comparing(Scope::getName, String.CASE_INSENSITIVE_ORDER);

    public ScopeRestService(ScopeResolver scopeResolver, I18nResolver i18nResolver, ApplicationProperties applicationProperties) {
        this.scopeResolver = scopeResolver;
        this.i18nResolver = i18nResolver;
        this.applicationProperties = applicationProperties;
        this.i18nKeyPrefix = "scopes.oauth2.scope.level." + this.getProduct() + ".";
    }

    private List<UntranslatedScope> resolveAvailableScopes() {
        return this.scopeResolver.getAvailableScopes().stream().sorted(this.ScopeSorter).map(scope -> {
            String name = scope.getName();
            Set grantTypes = scope.getSupportedGrantTypes();
            String scopeLowerCase = name.toLowerCase();
            String i18nSummaryKey = this.i18nKeyPrefix + scopeLowerCase + ".key";
            String i18nDescriptionKey = this.i18nKeyPrefix + scopeLowerCase + ".description";
            String i18nActionsPrefix = this.i18nKeyPrefix + scopeLowerCase + ".action";
            Set<String> consentedToScopeKeys = this.scopeResolver.getAutomaticallyConsentedToScopes(scope).stream().map(Scope::getName).collect(Collectors.toSet());
            return new UntranslatedScope(name, i18nSummaryKey, i18nDescriptionKey, i18nActionsPrefix, consentedToScopeKeys, grantTypes);
        }).collect(Collectors.toList());
    }

    private ScopeDto translateScope(UntranslatedScope scope) {
        String translatedDescription = this.i18nResolver.getText(scope.descriptionI18nKey);
        String translatedSummary = this.i18nResolver.getText(scope.summaryI18nKey);
        List<String> actions = this.resolveActionsForScope(scope.actionI18nPrefix, translatedDescription);
        return new ScopeDto(scope.name(), translatedSummary, translatedDescription, actions, scope.consentedToScopeKeys(), scope.grantTypes());
    }

    private List<String> resolveActionsForScope(String i18nKeyPrefix, String translatedDescription) {
        Map items = this.i18nResolver.getAllTranslationsForPrefix(i18nKeyPrefix);
        if (items.isEmpty()) {
            return List.of(translatedDescription);
        }
        return items.values().stream().toList();
    }

    public PageDto<ScopeDto> getAvailableScopes(int start, int limit, Set<String> grantTypes) {
        return new PageDto<ScopeDto>(start, limit, ((List)this.availableScopes.get()).size() <= start + limit, ((List)this.availableScopes.get()).stream().skip(start).limit(limit).filter(se -> {
            if (grantTypes.isEmpty()) return true;
            if (!se.grantTypes().stream().anyMatch(grantTypes::contains)) return false;
            return true;
        }).map(this::translateScope).toList());
    }

    private String getProduct() {
        return this.applicationProperties.getDisplayName().toLowerCase();
    }

    private record UntranslatedScope(String name, String summaryI18nKey, String descriptionI18nKey, String actionI18nPrefix, Set<String> consentedToScopeKeys, Set<String> grantTypes) {
    }
}

