/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.oauth2.provider.rest.service.grant;

import com.atlassian.oauth2.provider.api.token.access.AccessToken;
import com.atlassian.oauth2.provider.api.token.refresh.RefreshToken;
import com.atlassian.oauth2.provider.core.authorization.Authorization;
import com.atlassian.oauth2.provider.core.authorization.AuthorizationService;
import com.atlassian.oauth2.provider.core.authorization.TokenResponseErrorDescription;
import com.atlassian.oauth2.provider.core.token.JwtService;
import com.atlassian.oauth2.provider.core.token.TokenService;
import com.atlassian.oauth2.provider.rest.exception.InvalidRequestException;
import com.atlassian.oauth2.provider.rest.model.RestToken;
import com.atlassian.oauth2.provider.rest.model.TokenRequestFormParams;
import com.atlassian.oauth2.provider.rest.service.TokenRestService;
import com.atlassian.oauth2.provider.rest.service.grant.GrantProcessor;
import com.atlassian.oauth2.provider.rest.service.grant.GrantProcessorUtils;
import com.atlassian.oauth2.provider.rest.validation.grant.GrantValidator;
import com.atlassian.oauth2.scopes.api.Scope;
import com.atlassian.oauth2.scopes.api.ScopeResolver;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.Set;

public class AuthorizationCodeGrantProcessor
implements GrantProcessor {
    private final AuthorizationService authorizationService;
    private final I18nResolver i18nResolver;
    private final TokenService tokenService;
    private final GrantValidator grantValidator;
    private final JwtService jwtService;

    public AuthorizationCodeGrantProcessor(AuthorizationService authorizationService, I18nResolver i18nResolver, TokenService tokenService, GrantValidator grantValidator, JwtService jwtService) {
        this.authorizationService = authorizationService;
        this.i18nResolver = i18nResolver;
        this.tokenService = tokenService;
        this.grantValidator = grantValidator;
        this.jwtService = jwtService;
    }

    @Override
    public RestToken execute(TokenRequestFormParams formParams) {
        this.grantValidator.validate(formParams);
        return this.authorizationService.completeAuthorizationFlow(formParams.getClientId(), formParams.getRedirectUri(), formParams.getCode()).fold(authorization -> this.hasAuthorization((Authorization)authorization, formParams), this::missingAuthorization);
    }

    private RestToken hasAuthorization(Authorization authorization, TokenRequestFormParams formParams) {
        Set<Scope> fullSetOfGrantedScopes = GrantProcessorUtils.downgradeScope(authorization.getScopes(), "authorization_code");
        AccessToken accessToken = this.tokenService.createAccessToken(formParams.getClientId(), authorization.getUserKey(), formParams.getCode(), authorization.getCreatedAt(), fullSetOfGrantedScopes);
        RefreshToken refreshToken = this.tokenService.createRefreshToken(formParams.getClientId(), authorization.getUserKey(), authorization.getCreatedAt(), accessToken.getId(), fullSetOfGrantedScopes, formParams.getCode(), 0);
        return TokenRestService.tokenEntityToRestTokenWithRefresh(this.jwtService.createToken(accessToken.getId()), this.jwtService.createToken(refreshToken.getId()), ScopeResolver.serializeScopesToStr((Set)accessToken.getScopes()));
    }

    private RestToken missingAuthorization(TokenResponseErrorDescription tokenResponseErrorDescription) {
        throw new InvalidRequestException(this.i18nResolver.getText("oauth2.rest.error.authorization.code.invalid"));
    }
}

