/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.sal.api.features;

import com.atlassian.sal.api.features.EnabledDarkFeatures;
import com.atlassian.sal.api.features.FeatureKeyScope;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public class EnabledDarkFeaturesBuilder {
    private final ImmutableMap.Builder<FeatureKeyScope, Set<String>> builder = ImmutableMap.builder();

    public EnabledDarkFeaturesBuilder unmodifiableFeaturesEnabledForAllUsers(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.ALL_USERS_READ_ONLY, enabledFeatureKeys);
    }

    public EnabledDarkFeaturesBuilder featuresEnabledForAllUsers(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.ALL_USERS, enabledFeatureKeys);
    }

    public EnabledDarkFeaturesBuilder featuresEnabledForCurrentUser(@Nullable Set<String> enabledFeatureKeys) {
        return this.setEnabledFeatures(FeatureKeyScope.CURRENT_USER_ONLY, enabledFeatureKeys);
    }

    public EnabledDarkFeatures build() {
        return new EnabledDarkFeatures((Map<FeatureKeyScope, Set<String>>)this.builder.build());
    }

    private EnabledDarkFeaturesBuilder setEnabledFeatures(FeatureKeyScope featureKeyScope, @Nullable Set<String> enabledFeatureKeys) {
        Set<Object> nonNullCopy = enabledFeatureKeys != null ? Collections.unmodifiableSet(enabledFeatureKeys) : Collections.emptySet();
        this.builder.put((Object)featureKeyScope, nonNullCopy);
        return this;
    }
}

