/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.auth;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequestFactory;
import com.atlassian.applinks.api.auth.Anonymous;
import com.atlassian.applinks.api.auth.AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuth2AuthenticationProvider;
import com.atlassian.applinks.api.auth.types.TwoLeggedOAuthAuthenticationProvider;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.oauth.Consumer;
import com.atlassian.oauth.serviceprovider.ServiceProviderConsumerStore;
import com.atlassian.oauth2.scopes.api.ScopesRequestCache;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.OAuthRequestVerifierFactory;
import com.atlassian.sal.api.user.UserManager;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={RequestAuthorizor.class})
public class DefaultRequestAuthorizor
implements RequestAuthorizor {
    private static final Logger log = LoggerFactory.getLogger(DefaultRequestAuthorizor.class);
    public static final String ATLASSIAN_DEV_MODE = "atlassian.dev.mode";
    public static final String OAUTH_INCOMING_CONSUMER_KEY = "oauth.incoming.consumerkey";
    private static final String WRITE_SCOPE = "WRITE";
    private final OAuthRequestVerifierFactory oAuthRequestVerifierFactory;
    private final ServiceProviderConsumerStore consumerStore;
    private final UserManager userManager;
    private final ScopesRequestCache scopesRequestCache;
    private volatile RequestAuthorizor.Mode mode = RequestAuthorizor.Mode.NORMAL;

    @Autowired
    public DefaultRequestAuthorizor(@ComponentImport OAuthRequestVerifierFactory oAuthRequestVerifierFactory, @ComponentImport ServiceProviderConsumerStore consumerStore, @ComponentImport UserManager userManager, @ComponentImport ScopesRequestCache scopesRequestCache) {
        this.oAuthRequestVerifierFactory = oAuthRequestVerifierFactory;
        this.consumerStore = consumerStore;
        this.userManager = userManager;
        this.scopesRequestCache = scopesRequestCache;
    }

    @Override
    public boolean isAuthorized() {
        return switch (this.mode) {
            case RequestAuthorizor.Mode.ALLOW_ALL -> true;
            case RequestAuthorizor.Mode.BLOCK_ALL -> false;
            default -> this.validateOAuthOne2LOisAuthorised() || this.validateOAuthTwo2LOIsAuthorisedForWriteScope();
        };
    }

    @Override
    public boolean isAuthorized(String ... allowedScopes) {
        return switch (this.mode) {
            case RequestAuthorizor.Mode.ALLOW_ALL -> true;
            case RequestAuthorizor.Mode.BLOCK_ALL -> false;
            default -> this.validateOAuthOne2LOisAuthorised() || this.validateOauth2TwoLoIsAuthorizedWithScope(allowedScopes);
        };
    }

    @Override
    public void setMode(RequestAuthorizor.Mode mode) {
        if (!this.isDevMode()) {
            throw new UnsupportedOperationException("Setting the authorization mode is only available in dev-mode.\nUse the system property 'atlassian.dev.mode=true' to set this.");
        }
        this.mode = mode;
    }

    @Override
    public Iterable<Class<? extends AuthenticationProvider>> getAllowedAuthenticationProviders() {
        return List.of(TwoLeggedOAuthAuthenticationProvider.class, TwoLeggedOAuth2AuthenticationProvider.class);
    }

    @Override
    public Map<Class<? extends AuthenticationProvider>, Boolean> getAuthenticationProviderStatuses(ApplicationLink applicationLink) {
        return Map.of(TwoLeggedOAuthAuthenticationProvider.class, this.is2LOConfigured(applicationLink), TwoLeggedOAuth2AuthenticationProvider.class, this.is2LOConfiguredOAuth2(applicationLink));
    }

    @Override
    public ApplicationLinkRequestFactory getAuthorizedRequestFactory(ApplicationLink applicationLink) {
        ApplicationLinkRequestFactory factory = null;
        if (this.is2LOConfiguredOAuth2(applicationLink)) {
            factory = applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuth2AuthenticationProvider.class);
        } else if (this.is2LOConfigured(applicationLink)) {
            factory = applicationLink.createAuthenticatedRequestFactory(TwoLeggedOAuthAuthenticationProvider.class);
        } else {
            log.debug("Missing 2LO for {}, trying anonymous", (Object)applicationLink);
        }
        return factory != null ? factory : applicationLink.createAuthenticatedRequestFactory(Anonymous.class);
    }

    private boolean is2LOConfigured(ApplicationLink applicationLink) {
        Consumer consumer;
        Object consumerKey = applicationLink.getProperty(OAUTH_INCOMING_CONSUMER_KEY);
        if (consumerKey != null && (consumer = this.consumerStore.get(consumerKey.toString())) != null) {
            return consumer.getTwoLOAllowed();
        }
        return false;
    }

    private boolean is2LOConfiguredOAuth2(ApplicationLink applicationLink) {
        return applicationLink.getClientCredentialsClientConfigurationId() != null && !applicationLink.getClientCredentialsClientConfigurationId().isEmpty();
    }

    private boolean validateOAuthOne2LOisAuthorised() {
        return this.oAuthRequestVerifierFactory.getInstance(null).isVerified() && this.userManager.getRemoteUserKey() == null;
    }

    private boolean validateOAuthTwo2LOIsAuthorisedForWriteScope() {
        return this.validateOauth2TwoLoIsAuthorizedWithScope(WRITE_SCOPE);
    }

    private boolean validateOauth2TwoLoIsAuthorizedWithScope(String ... allowedScopes) {
        if (this.userManager.getRemoteUserKey() != null) {
            return false;
        }
        if (allowedScopes == null) {
            return false;
        }
        for (String scope : allowedScopes) {
            if (!this.scopesRequestCache.isScopePermitted(scope)) continue;
            return true;
        }
        return false;
    }

    private boolean isDevMode() {
        return Boolean.getBoolean(ATLASSIAN_DEV_MODE);
    }
}

