/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.http;

import com.atlassian.event.remote.impl.http.HttpClientFactory;
import com.atlassian.event.remote.internal.http.HttpRequestService;
import com.atlassian.event.remote.internal.http.ResponseBodyHandler;
import com.atlassian.failurecache.util.date.Clock;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.ApplicationProperties;
import io.atlassian.util.concurrent.LazyReference;
import io.atlassian.util.concurrent.ResettableLazyReference;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.BasicResponseHandler;
import org.apache.http.util.EntityUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={HttpRequestService.class})
public class DefaultHttpRequestService
implements HttpRequestService {
    private final ResponseHandler<String> basicResponseHandler;
    private final ApplicationProperties applicationProperties;
    private final ResettableLazyReference<HttpClient> client;
    private final Clock clock;
    private final LazyReference<String> userAgent;

    @Autowired
    public DefaultHttpRequestService(@ComponentImport ApplicationProperties applicationProperties, final HttpClientFactory clientFactory, @ComponentImport Clock clock) {
        this.applicationProperties = applicationProperties;
        this.clock = clock;
        this.basicResponseHandler = new BasicResponseHandler();
        this.client = new ResettableLazyReference<HttpClient>(this){

            protected HttpClient create() throws Exception {
                return clientFactory.createHttpClient();
            }
        };
        this.userAgent = new LazyReference<String>(){

            protected String create() throws Exception {
                return DefaultHttpRequestService.this.createUserAgent();
            }
        };
    }

    @Override
    public <T> T get(String url, ResponseBodyHandler<T> subscriptionHandler) throws IOException {
        return (T)((HttpClient)this.client.get()).execute((HttpUriRequest)this.createGetRequest(url), new DelegatingResponseHandler<T>(subscriptionHandler));
    }

    private HttpGet createGetRequest(String url) {
        HttpGet request = new HttpGet(url);
        request.setHeader("Accept", "application/json");
        request.setHeader("Content-Type", "application/json");
        request.setHeader("User-Agent", (String)this.userAgent.get());
        return request;
    }

    private String createUserAgent() {
        return String.format("%s-%s (%s)", this.applicationProperties.getDisplayName(), this.applicationProperties.getVersion(), this.applicationProperties.getBuildNumber());
    }

    private long getHeaderValue(Header[] headers, String element, long defaultValue) {
        try {
            for (Header header : headers) {
                for (HeaderElement e : header.getElements()) {
                    if (!e.getName().equalsIgnoreCase(element) || e.getValue() == null) continue;
                    return TimeUnit.SECONDS.toMillis(Long.parseLong(e.getValue()));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return defaultValue;
    }

    private class DelegatingResponseHandler<T>
    implements ResponseHandler<T> {
        private final ResponseBodyHandler<T> subscriptionHandler;

        public DelegatingResponseHandler(ResponseBodyHandler<T> subscriptionHandler) {
            this.subscriptionHandler = subscriptionHandler;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public T handleResponse(HttpResponse response) throws IOException {
            try {
                long now = DefaultHttpRequestService.this.clock.getCurrentDate().getTime();
                long maxAge = DefaultHttpRequestService.this.getHeaderValue(response.getHeaders("Cache-Control"), "max-age", 0L);
                long staleInMillis = DefaultHttpRequestService.this.getHeaderValue(response.getHeaders("Cache-Control"), "stale-while-revalidate", 0L);
                String body = (String)DefaultHttpRequestService.this.basicResponseHandler.handleResponse(response);
                long staleAfterInMillis = now + maxAge;
                T t = this.subscriptionHandler.handle(body, staleAfterInMillis, staleAfterInMillis + staleInMillis);
                return t;
            }
            finally {
                if (response != null) {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }
        }
    }
}

