/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.http;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.event.remote.internal.http.HttpUtil;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugins.capabilities.api.LinkedAppWithCapabilities;
import com.atlassian.plugins.capabilities.api.LinkedApplicationCapabilities;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import io.atlassian.util.concurrent.LazyReference;
import jakarta.ws.rs.core.CacheControl;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ExportAsService(value={HttpUtil.class})
public class DefaultHttpUtil
implements HttpUtil {
    private final ApplicationProperties applicationProperties;
    private final ApplicationLinkService applicationLinkService;
    private final LinkedApplicationCapabilities applicationCapabilities;
    private final LazyReference<CacheControl> cacheControl = new LazyReference<CacheControl>(this){

        protected CacheControl create() throws Exception {
            CacheControl cacheControl = new CacheControl();
            cacheControl.setMaxAge((int)HttpUtil.MAX_AGE.getSeconds());
            cacheControl.getCacheExtension().put("stale-while-revalidate", Long.toString(HttpUtil.STALE_WHILE_REVALIDATE.getSeconds()));
            cacheControl.getCacheExtension().put("stale-if-error", Long.toString(HttpUtil.STALE_IF_ERROR.getSeconds()));
            return cacheControl;
        }
    };

    @Autowired
    public DefaultHttpUtil(@ComponentImport ApplicationProperties applicationProperties, @ComponentImport ApplicationLinkService applicationLinkService, @ComponentImport LinkedApplicationCapabilities applicationCapabilities) {
        this.applicationProperties = applicationProperties;
        this.applicationLinkService = applicationLinkService;
        this.applicationCapabilities = applicationCapabilities;
    }

    @Override
    public LinkedAppWithCapabilities getAppWithCapabilities(String applicationLinkId, String capability) {
        return this.getLinkedAppsSupportingStatus(capability).stream().filter(input -> input != null && applicationLinkId.equals(input.getApplicationLinkId())).findFirst().orElse(null);
    }

    @Override
    public String getCapabilityUrl(LinkedAppWithCapabilities app, String capability) throws TypeNotInstalledException {
        String path = app.getCapabilityUrl(capability);
        ApplicationLink appLink = this.applicationLinkService.getApplicationLink(new ApplicationId(app.getApplicationLinkId()));
        return path == null ? null : this.getUrlString(appLink.getRpcUrl().toASCIIString(), path);
    }

    @Override
    public Set<? extends LinkedAppWithCapabilities> getLinkedAppsSupportingStatus(String capability) {
        return this.applicationCapabilities.capableOf(capability);
    }

    @Override
    public Response getOkJsonResponse(Object body) {
        Response.ResponseBuilder response = Response.ok((Object)body, (MediaType)MediaType.APPLICATION_JSON_TYPE);
        response.cacheControl((CacheControl)this.cacheControl.get());
        return response.build();
    }

    @Override
    public URI getUrlOnThisHost(String stub) throws URISyntaxException {
        String hostUrl = this.applicationProperties.getBaseUrl(UrlMode.CANONICAL);
        return this.getUrl(hostUrl, stub);
    }

    @Override
    public URI getUrl(String hostUrl, String stub) throws URISyntaxException {
        return new URI(this.getUrlString(hostUrl, stub));
    }

    private String getUrlString(String hostUrl, String stub) {
        if (this.isAbsolute(stub)) {
            return stub;
        }
        hostUrl = hostUrl.endsWith("/") ? hostUrl.substring(0, hostUrl.length() - 1) : hostUrl;
        String slash = stub.startsWith("/") ? "" : "/";
        return hostUrl + slash + stub;
    }

    private boolean isAbsolute(String url) {
        try {
            return new URI(url).isAbsolute();
        }
        catch (URISyntaxException e) {
            return false;
        }
    }
}

