/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.event.remote.impl.rest;

import com.atlassian.annotations.security.ScopesAllowed;
import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatus;
import com.atlassian.event.remote.impl.diagnostics.RemoteStatusCallback;
import com.atlassian.event.remote.internal.auth.RequestAuthorizor;
import com.atlassian.event.remote.internal.json.JsonUtil;
import com.atlassian.plugins.rest.api.security.annotation.UnrestrictedAccess;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/")
@Singleton
public class RemoteEventCommonResource {
    public static final String URL_HASH = "urlHash";
    public static final String RESET = "reset";
    private static final Logger log = LoggerFactory.getLogger(RemoteEventCommonResource.class);
    private static final String READ_SCOPE = "READ";
    private static final String BITBUCKET_PUBLIC_REPOS_SCOPE = "PUBLIC_REPOS";
    private final ApplicationLinkService applicationLinks;
    private final JsonUtil jsonUtil;
    private final RemoteStatusCallback connectionStatus;
    private final RequestAuthorizor requestAuthorizor;

    @Inject
    public RemoteEventCommonResource(ApplicationLinkService applicationLinks, JsonUtil jsonUtil, RemoteStatusCallback connectionStatus, RequestAuthorizor requestAuthorizor) {
        this.applicationLinks = applicationLinks;
        this.connectionStatus = connectionStatus;
        this.jsonUtil = jsonUtil;
        this.requestAuthorizor = requestAuthorizor;
    }

    @GET
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"READ", "PUBLIC_REPOS"})
    @Path(value="status")
    public Response status() {
        String[] allowedScopes = new Object(this){}.getClass().getEnclosingMethod().getAnnotation(ScopesAllowed.class).requiredScope();
        if (this.requestAuthorizor.isAuthorized(allowedScopes)) {
            return Response.ok((Object)"OK").build();
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    @GET
    @UnrestrictedAccess
    @ScopesAllowed(requiredScope={"READ", "PUBLIC_REPOS"})
    @Path(value="status/{applicationId}")
    public Response statusCallback(@PathParam(value="applicationId") String applicationId, @QueryParam(value="urlHash") String urlHash) {
        String[] allowedScopes = new Object(this){}.getClass().getEnclosingMethod().getAnnotation(ScopesAllowed.class).requiredScope();
        if (this.requestAuthorizor.isAuthorized(allowedScopes)) {
            try {
                ApplicationLink applicationLink = this.getApplicationLink(applicationId, urlHash);
                RemoteStatus remoteStatus = RemoteStatus.EMPTY_STATUS;
                if (applicationLink != null) {
                    remoteStatus = this.connectionStatus.get(applicationLink);
                } else {
                    log.info("Missing expected AppLink with remote host ID " + applicationId + " and URL hash " + urlHash);
                }
                return Response.ok((Object)this.jsonUtil.write(remoteStatus), (MediaType)MediaType.APPLICATION_JSON_TYPE).build();
            }
            catch (Exception e) {
                log.info("Exception while accessing AppLink with remote host ID " + applicationId + " and URL hash " + urlHash, (Throwable)e);
                return Response.serverError().build();
            }
        }
        return Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
    }

    private ApplicationLink getApplicationLink(String applicationId, String urlHash) throws TypeNotInstalledException {
        ApplicationLink applicationLink = this.applicationLinks.getApplicationLink(new ApplicationId(applicationId));
        return applicationLink == null && urlHash != null ? this.applicationLinks.getApplicationLink(new ApplicationId(urlHash)) : applicationLink;
    }
}

